/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.db;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.ai.gai.dataentity.resource.ResManager;
import kd.ai.gai.flow.db.Column;
import kd.ai.gai.flow.db.Schema;
import kd.ai.gai.flow.dt.D;
import kd.ai.gai.flow.except.IscBizException;

public class GeneralSchema
implements Schema {
    private Map<String, Integer> lookup;
    private Column[] fields;
    private String pk;
    private String name;

    public GeneralSchema(Collection<Column> fields, String pk, String name) {
        this.registerFields(fields);
        this.checkDuplicatedFields();
        this.pk = D.s(pk);
        this.name = name;
    }

    public GeneralSchema(Collection<Column> fields) {
        this(fields, null, null);
    }

    public GeneralSchema(ResultSetMetaData rs) throws SQLException {
        this.registerFields(rs);
        this.checkDuplicatedFields();
    }

    private void registerFields(Collection<Column> fields) {
        int count = fields.size();
        this.lookup = new LinkedHashMap<String, Integer>(count << 2);
        this.fields = new Column[count];
        int i = 0;
        for (Column field : fields) {
            this.lookup.put(field.getName(), i);
            this.fields[i] = field;
            ++i;
        }
    }

    private void checkDuplicatedFields() {
        if (this.lookup.size() != this.fields.length) {
            throw new IllegalArgumentException("exists duplicated field name.");
        }
    }

    private void registerFields(ResultSetMetaData rs) throws SQLException {
        int count = rs.getColumnCount();
        this.lookup = new LinkedHashMap<String, Integer>(count << 1);
        this.fields = new Column[count];
        for (int i = 0; i < count; ++i) {
            Column field = new Column(rs, i);
            this.lookup.put(field.getName(), i);
            this.fields[i] = field;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQuotedName() {
        return this.name;
    }

    @Override
    public String getPrimaryKeyName() {
        return this.pk;
    }

    @Override
    public Column getField(int index) {
        return this.fields[index];
    }

    @Override
    public int getIndex(String name) {
        Integer i = this.lookup.get(name);
        if (i == null) {
            return -1;
        }
        return i;
    }

    @Override
    public Column getField(String name) {
        Integer i = this.lookup.get(name);
        if (i != null) {
            return this.fields[i];
        }
        throw new IscBizException(String.format(ResManager.loadKDString("\u5b57\u6bb5\uff08%s\uff09\u4e0d\u5b58\u5728\uff01", "GeneralSchema_2", "isc-iscb-util", new Object[0]), name));
    }

    @Override
    public Column findField(String column) {
        Integer i = this.lookup.get(column);
        return i == null ? null : this.fields[i];
    }

    @Override
    public boolean hasField(String key) {
        return this.lookup.containsKey(key);
    }

    @Override
    public int getFieldCount() {
        return this.fields.length;
    }
}

