/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.ai.gai.dataentity.resource.ResManager;
import kd.ai.gai.flow.db.Column;
import kd.ai.gai.flow.db.DbUtil;
import kd.ai.gai.flow.db.FieldsNotFoundException;
import kd.ai.gai.flow.db.Schema;
import kd.ai.gai.flow.dt.D;
import kd.ai.gai.flow.dt.DataType;
import kd.ai.gai.flow.except.IscBizException;

public final class Table
implements Schema {
    private String name;
    private char quot;
    private Map<String, Column> fieldMap = new HashMap<String, Column>();
    private Column[] fieldList;
    private Column pk;
    private List<Column> pks;
    private String remark;

    public Table(Connection cn, String name, char quot) {
        try {
            this.init(cn, name, quot);
        }
        catch (SQLException e) {
            throw new IscBizException(e);
        }
    }

    public Table(String name, char quot, List<Map<String, Object>> fields, List<String> primaryKeys) {
        this.name = name;
        this.quot = quot;
        int index = 0;
        ArrayList<Column> fieldList = new ArrayList<Column>();
        for (Map<String, Object> item : fields) {
            Column field = new Column(item, index, quot);
            String key = field.getName();
            if (this.fieldMap.containsKey(key)) continue;
            fieldList.add(field);
            this.fieldMap.put(key, field);
            ++index;
        }
        this.fieldList = fieldList.toArray(new Column[fieldList.size()]);
        HashSet<String> set = new HashSet<String>(primaryKeys);
        for (String pk : set) {
            Column field = this.fieldMap.get(pk.toLowerCase());
            field.setPrimaryKey();
            this.pk = field;
        }
        if (set.size() > 1) {
            this.pk = null;
        }
        this.initPrimaryKeys();
    }

    private void initPrimaryKeys() {
        ArrayList<Column> pks = new ArrayList<Column>(1);
        for (Column c : this.fieldList) {
            if (!c.isPrimaryKey()) continue;
            pks.add(c);
        }
        this.pks = pks.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(pks);
    }

    private void init(Connection cn, String name, char quot) throws SQLException {
        this.name = name;
        this.quot = quot;
        DatabaseMetaData meta = cn.getMetaData();
        this.loadFields(name, meta);
        this.loadPrimaryKey(name, meta);
        this.fieldMap = Collections.unmodifiableMap(this.fieldMap);
        this.initPrimaryKeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPrimaryKey(String name, DatabaseMetaData meta) throws SQLException {
        boolean hasMultiPK = false;
        String catalog = meta.getConnection().getCatalog();
        String schema = Table.getSchema(meta);
        ResultSet rs = this.getPrimaryKeyResultSet(meta, name, catalog, schema);
        ResultSet tables = meta.getTables(catalog, schema, name, new String[]{"TABLE"});
        if (tables.next()) {
            this.remark = tables.getString("REMARKS");
        }
        if (rs == null) {
            this.pk = null;
            return;
        }
        try {
            do {
                if (this.pk != null) {
                    hasMultiPK = true;
                }
                String pkName = rs.getString("COLUMN_NAME").toLowerCase();
                this.pk = this.fieldMap.get(pkName);
                this.pk.setPrimaryKey();
            } while (rs.next());
        }
        finally {
            DbUtil.close(rs);
        }
        if (hasMultiPK) {
            this.pk = null;
        }
        if (this.pk != null && !this.fieldMap.containsKey("id")) {
            this.fieldMap.put("id", this.pk);
        }
    }

    private ResultSet getPrimaryKeyResultSet(DatabaseMetaData meta, String name, String catalog, String schema) throws SQLException {
        ResultSet rs = this.tryGetPrimaryKeyResultSet(meta, name, catalog, schema);
        if (rs != null) {
            return rs;
        }
        rs = this.tryGetPrimaryKeyResultSet(meta, name.toUpperCase(), catalog, schema);
        if (rs != null) {
            return rs;
        }
        return this.tryGetPrimaryKeyResultSet(meta, name.toLowerCase(), catalog, schema);
    }

    private ResultSet tryGetPrimaryKeyResultSet(DatabaseMetaData meta, String name, String catalog, String schema) throws SQLException {
        ResultSet rs = meta.getPrimaryKeys(catalog, schema, name);
        try {
            if (rs.next()) {
                return rs;
            }
            DbUtil.close(rs);
            return null;
        }
        catch (SQLException e) {
            DbUtil.close(rs);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFields(String name, DatabaseMetaData meta) throws SQLException {
        ResultSet rs = this.getColumnResultSet(name, meta);
        try {
            ArrayList<Column> fields = new ArrayList<Column>();
            int i = 0;
            do {
                Column f;
                if (!name.equalsIgnoreCase(rs.getString("TABLE_NAME")) || this.fieldMap.containsKey((f = new Column(rs, i, this.quot, meta)).getName())) continue;
                this.fieldMap.put(f.getName(), f);
                fields.add(f);
                ++i;
            } while (rs.next());
            this.fieldList = fields.toArray(new Column[fields.size()]);
        }
        finally {
            DbUtil.close(rs);
        }
    }

    private ResultSet getColumnResultSet(String name, DatabaseMetaData meta) throws SQLException {
        ResultSet rs = this.tryGetColumnResultSet(meta, name);
        if (rs != null) {
            return rs;
        }
        rs = this.tryGetColumnResultSet(meta, name.toUpperCase());
        if (rs != null) {
            return rs;
        }
        rs = this.tryGetColumnResultSet(meta, name.toLowerCase());
        if (rs != null) {
            return rs;
        }
        throw new FieldsNotFoundException(String.format(ResManager.loadKDString("\u6570\u636e\u8868'%s'\u7684\u5b57\u6bb5\u4fe1\u606f\u4e0d\u5b58\u5728\uff01", "Table_5", "isc-iscb-util", new Object[0]), name));
    }

    private ResultSet tryGetColumnResultSet(DatabaseMetaData meta, String name) throws SQLException {
        String catalog = meta.getConnection().getCatalog();
        String schema = Table.getSchema(meta);
        ResultSet rs = meta.getColumns(catalog, schema, name, "%");
        try {
            if (rs.next()) {
                return rs;
            }
            DbUtil.close(rs);
            return null;
        }
        catch (SQLException e) {
            DbUtil.close(rs);
            return null;
        }
    }

    public static String getSchema(DatabaseMetaData meta) throws SQLException {
        String schema = DbUtil.getSchema(meta.getConnection());
        if (schema == null && meta.getClass().getName().startsWith("com.huawei.gauss.jdbc")) {
            schema = D.s(DbUtil.executeScalar(meta.getConnection(), "SELECT USER FROM DUAL"));
        }
        return schema;
    }

    @Override
    public Column getField(String column) {
        Column field = this.fieldMap.get(column);
        if (field != null) {
            return field;
        }
        throw new IscBizException(String.format(ResManager.loadKDString("\u5b57\u6bb5\uff08%1$s\uff09\u5728\u6570\u636e\u8868\uff08%2$s\uff09\u4e2d\u4e0d\u5b58\u5728\uff01", "Table_6", "isc-iscb-util", new Object[0]), column, this.name));
    }

    @Override
    public Column findField(String column) {
        return this.fieldMap.get(column);
    }

    public StringBuilder generateSelect(String[] fields) {
        StringBuilder sql = new StringBuilder();
        boolean first = true;
        for (String name : fields) {
            if (first) {
                first = false;
            } else {
                sql.append(", ");
            }
            Column field = this.fieldMap.get(name);
            if (field != null) {
                sql.append(field.getBinding());
                continue;
            }
            if (name.indexOf(" AS ") > 0) {
                sql.append(name);
                continue;
            }
            throw new IscBizException("field {" + name + "} not exists in table " + this.name);
        }
        sql.append(" FROM ").append(this.name).append("\r\n");
        return sql;
    }

    public void generateOrderBy(StringBuilder sql, String orderBy) {
        if (orderBy == null || orderBy.length() == 0) {
            return;
        }
        sql.append(" ORDER BY ");
        String[] items = orderBy.split(",");
        for (int i = 0; i < items.length; ++i) {
            this.appendOrderByItem(sql, items[i], i);
        }
    }

    private void appendOrderByItem(StringBuilder sql, String item, int i) {
        String column = item;
        String sorting = "asc";
        if (item.contains(" ")) {
            String[] tmp = item.split("\\ +");
            column = tmp[0];
            sorting = tmp[1];
        }
        Column field = this.getField(column);
        if (i > 0) {
            sql.append(", ");
        }
        sql.append(field.getBinding());
        if ("desc".equalsIgnoreCase(sorting)) {
            sql.append(" desc");
        }
    }

    public StringBuilder prepareInsertSql(Map<String, Object> data, List<Object> values, List<Integer> types) {
        StringBuilder sql0 = new StringBuilder();
        StringBuilder sql1 = new StringBuilder();
        sql0.append("INSERT INTO ").append(this.name).append('(');
        sql1.append("VALUES(");
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            this.appendFieldForInsert(sql0, sql1, values, types, entry);
        }
        sql0.append(')');
        sql1.append(')');
        sql0.append((CharSequence)sql1);
        return sql0;
    }

    private void appendFieldForInsert(StringBuilder sql0, StringBuilder sql1, List<Object> values, List<Integer> types, Map.Entry<String, ?> entry) {
        Column field = this.fieldMap.get(entry.getKey());
        if (field == null) {
            return;
        }
        if (values.size() > 0) {
            sql0.append(',');
            sql1.append(',');
        }
        Object value = this.checkValue(entry.getValue(), field);
        sql0.append(field.getBinding());
        sql1.append('?');
        values.add(value);
        types.add(field.getSqlType());
    }

    public StringBuilder prepareUpdateSql(Map<String, ?> data, List<Object> values, List<Integer> types) {
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ").append(this.name).append(" set ");
        for (Map.Entry<String, ?> entry : data.entrySet()) {
            Column field = this.fieldMap.get(entry.getKey());
            if (field == null) continue;
            if (values.size() > 0) {
                sql.append(',');
            }
            sql.append(field.getBinding()).append("= ?");
            Object value = this.checkValue(entry.getValue(), field);
            values.add(value);
            types.add(field.getSqlType());
        }
        return sql;
    }

    private Object checkValue(Object input, Column field) {
        DataType type = field.getDataType();
        Object value = type.narrow(input);
        if (value != null) {
            return type.forSave(value);
        }
        return null;
    }

    @Override
    public int getFieldCount() {
        return this.fieldList.length;
    }

    public int getFieldIndex(String field) {
        Column f = this.fieldMap.get(field);
        if (f == null) {
            return -1;
        }
        return f.getIndex();
    }

    @Override
    public Column getField(int index) {
        return this.fieldList[index];
    }

    public char getQuot() {
        return this.quot;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQuotedName() {
        if (this.startWithNumber(this.name) || this.name.contains(":")) {
            return this.quot + this.name + this.quot;
        }
        return this.name;
    }

    private boolean startWithNumber(String name) {
        char first = name.charAt(0);
        return first >= '0' && first <= '9';
    }

    public Map<String, Column> getFieldMap() {
        return this.fieldMap;
    }

    public String toString() {
        return this.name;
    }

    public Column getPrimaryKey() {
        return this.pk;
    }

    public List<Column> getPrimaryKeys() {
        return this.pks;
    }

    public String getRemark() {
        return this.remark;
    }

    @Override
    public String getPrimaryKeyName() {
        return this.pk == null ? null : this.pk.getName();
    }

    @Override
    public int getIndex(String name) {
        Column column = this.fieldMap.get(name);
        if (column == null) {
            return -1;
        }
        return column.getIndex();
    }

    @Override
    public boolean hasField(String name) {
        return this.fieldMap.containsKey(name);
    }
}

