/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.db.type;

import java.sql.Connection;
import java.util.Locale;
import kd.ai.gai.dataentity.resource.ResManager;
import kd.ai.gai.flow.db.Column;
import kd.ai.gai.flow.db.DbType;
import kd.ai.gai.flow.db.Table;

public class DmDbType
implements DbType {
    @Override
    public String getDataType(Column c) {
        int scale = c.getScale();
        int length = c.getPrecision();
        switch (c.getOrginalSqlType()) {
            case -6: {
                return "TINYINT";
            }
            case 5: {
                return "SMALLINT";
            }
            case 4: {
                return "INTEGER";
            }
            case -5: {
                return "BIGINT";
            }
            case -4: 
            case 2004: {
                return "BLOB";
            }
            case -16: 
            case -1: 
            case 2005: 
            case 2011: {
                return "TEXT";
            }
            case -2: {
                if (length <= 2000) {
                    return "BINARY(" + length + ")";
                }
                return "BLOB";
            }
            case -3: {
                if (length <= 2000) {
                    return "BINARY(" + length + ")";
                }
                return "BLOB";
            }
            case -9: 
            case 12: {
                if (length <= 2000) {
                    return "VARCHAR(" + length + " char)";
                }
                return "TEXT";
            }
            case 1: {
                return "CHAR(" + length + ")";
            }
            case -15: {
                return "NCHAR(" + length + ")";
            }
            case -7: {
                return "BIT";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP(" + Math.min(6, scale) + ")";
            }
            case 2: 
            case 3: {
                return "DECIMAL(" + length + "," + scale + ")";
            }
            case 7: {
                return "REAL";
            }
            case 6: {
                return "FLOAT";
            }
            case 8: {
                return "DOUBLE";
            }
            case -8: {
                return "VARBINARY(16)";
            }
        }
        throw new UnsupportedOperationException(String.format(ResManager.loadKDString("\u4e0d\u652f\u6301\u6570\u636e\u7c7b\u578b\uff08%s\uff09", "DmDbType_1", "isc-iscb-util", new Object[0]), c.getOrginalSqlType()));
    }

    @Override
    public String qualifyTableName(String tableName) {
        return tableName.toLowerCase(Locale.ENGLISH);
    }

    @Override
    public String qualifyColumnName(String columnName) {
        return columnName.toLowerCase(Locale.ENGLISH);
    }

    @Override
    public char getQuotChar() {
        return '\"';
    }

    @Override
    public void setBigQuery(Connection src) {
    }

    @Override
    public void unsetBigQuery(Connection src) {
    }

    @Override
    public String emtpyTableTestSQL(Table table) {
        return "SELECT TOP 1 1 AS X FROM " + table.getQuotedName();
    }
}

