/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.db.type;

import java.sql.Connection;
import java.util.Locale;
import kd.ai.gai.dataentity.resource.ResManager;
import kd.ai.gai.flow.db.Column;
import kd.ai.gai.flow.db.DbType;
import kd.ai.gai.flow.db.Table;

public class MySqlDbType
implements DbType {
    @Override
    public String getDataType(Column c) {
        int length = c.getPrecision();
        switch (c.getOrginalSqlType()) {
            case -6: {
                return "TINYINT";
            }
            case 5: {
                return "SMALLINT";
            }
            case 4: {
                return "INTEGER";
            }
            case -5: {
                return "BIGINT";
            }
            case -4: 
            case 2004: {
                return "longblob";
            }
            case -16: 
            case -1: 
            case 2005: 
            case 2011: {
                return "LONGTEXT";
            }
            case -3: 
            case -2: {
                if (length <= 4000) {
                    return "VARBINARY(" + length + ")";
                }
                return "longblob";
            }
            case -9: 
            case 12: {
                if (length <= 4000) {
                    return "VARCHAR(" + length + ")";
                }
                return "LONGTEXT";
            }
            case -15: 
            case 1: {
                return "CHAR(" + length + ")";
            }
            case -7: {
                return "BIT";
            }
            case 93: {
                return "DATETIME";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 2: 
            case 3: {
                return "DECIMAL(" + length + "," + c.getScale() + ")";
            }
            case 6: 
            case 7: 
            case 8: {
                return "FLOAT";
            }
            case -8: {
                return "BINARY(16)";
            }
        }
        throw new UnsupportedOperationException(String.format(ResManager.loadKDString("\u4e0d\u652f\u6301\u6570\u636e\u7c7b\u578b\uff08%s\uff09", "MySqlDbType_1", "isc-iscb-util", new Object[0]), c.getOrginalSqlType()));
    }

    @Override
    public String qualifyTableName(String tableName) {
        return tableName.toLowerCase(Locale.ENGLISH);
    }

    @Override
    public String qualifyColumnName(String columnName) {
        return columnName.toLowerCase(Locale.ENGLISH);
    }

    @Override
    public char getQuotChar() {
        return '`';
    }

    @Override
    public void setBigQuery(Connection src) {
    }

    @Override
    public void unsetBigQuery(Connection src) {
    }

    @Override
    public String emtpyTableTestSQL(Table table) {
        return "SELECT 1 FROM " + table.getQuotedName() + " LIMIT 0,1";
    }
}

