/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.db.type;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Locale;
import kd.ai.gai.dataentity.resource.ResManager;
import kd.ai.gai.flow.db.Column;
import kd.ai.gai.flow.db.DbType;
import kd.ai.gai.flow.db.Table;

public class PostgreSqlDbType
implements DbType {
    @Override
    public String getDataType(Column c) {
        int length = c.getPrecision();
        switch (c.getOrginalSqlType()) {
            case -6: 
            case 5: {
                return "smallint";
            }
            case 4: {
                return "integer";
            }
            case -5: {
                return "bigint";
            }
            case -4: 
            case 2004: {
                return "bytea";
            }
            case -16: 
            case -1: 
            case 2005: 
            case 2011: {
                return "TEXT";
            }
            case -3: 
            case -2: {
                return "bytea";
            }
            case -9: 
            case 12: {
                if (length <= 4000) {
                    return "varchar(" + length + ")";
                }
                return "text";
            }
            case -15: 
            case 1: {
                return "char(" + length + ")";
            }
            case -7: {
                return "boolean";
            }
            case 93: {
                return "TIMESTAMP WITHOUT TIME ZONE";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME WITHOUT TIME ZONE";
            }
            case 2: 
            case 3: {
                return "NUMERIC(" + length + "," + c.getScale() + ")";
            }
            case 6: 
            case 7: 
            case 8: {
                return "float(53)";
            }
            case -8: {
                return "bytea";
            }
        }
        throw new UnsupportedOperationException(String.format(ResManager.loadKDString("\u4e0d\u652f\u6301\u6570\u636e\u7c7b\u578b\uff08%s\uff09", "PostgreSqlDbType_1", "isc-iscb-util", new Object[0]), c.getOrginalSqlType()));
    }

    @Override
    public String qualifyTableName(String tableName) {
        return tableName.toLowerCase(Locale.ENGLISH);
    }

    @Override
    public String qualifyColumnName(String columnName) {
        return columnName.toLowerCase(Locale.ENGLISH);
    }

    @Override
    public char getQuotChar() {
        return '\"';
    }

    @Override
    public void setBigQuery(Connection cn) throws SQLException {
        cn.setAutoCommit(false);
    }

    @Override
    public void unsetBigQuery(Connection cn) throws SQLException {
        cn.setAutoCommit(true);
    }

    @Override
    public String emtpyTableTestSQL(Table table) {
        return "SELECT 1 FROM " + table.getQuotedName() + " LIMIT 1 OFFSET 0";
    }
}

