/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.dt;

import kd.ai.gai.flow.dt.CollectionDataType;
import kd.ai.gai.flow.dt.DataType;
import kd.ai.gai.flow.dt.ListType;
import kd.ai.gai.flow.dt.i.BinaryType;
import kd.ai.gai.flow.dt.i.BooleanType;
import kd.ai.gai.flow.dt.i.DateTimeType;
import kd.ai.gai.flow.dt.i.DateType;
import kd.ai.gai.flow.dt.i.DecimalType;
import kd.ai.gai.flow.dt.i.DoubleType;
import kd.ai.gai.flow.dt.i.IntegerType;
import kd.ai.gai.flow.dt.i.LongType;
import kd.ai.gai.flow.dt.i.StringType;
import kd.ai.gai.flow.dt.i.StringType2;
import kd.ai.gai.flow.dt.i.TimeType;
import kd.ai.gai.flow.dt.i.UnknownType;

public final class DataTypes {
    public static final DataType BOOLEAN = new BooleanType();
    public static final DataType INTEGER = new IntegerType();
    public static final DataType LONG = new LongType();
    public static final DataType BINARY = new BinaryType(0);
    public static final DataType BINARY16 = new BinaryType(16);
    public static final DataType DATETIME = new DateTimeType();
    public static final DataType DATE = new DateType();
    public static final DataType TIME = new TimeType();
    public static final DataType DECIMAL = DecimalType.getType(-1, -1);
    public static final DataType STRING = new StringType(0, true);
    public static final DataType STRING2 = new StringType2();
    public static final DataType UNKNOWN = new UnknownType();
    public static final DataType DOUBLE = new DoubleType();

    public static CollectionDataType listType(DataType elementType) {
        return new ListType(elementType);
    }

    public static DataType get(String type) {
        if ("string".equals(type)) {
            return STRING;
        }
        if ("integer".equals(type)) {
            return INTEGER;
        }
        if ("int".equals(type)) {
            return INTEGER;
        }
        if ("decimal".equals(type)) {
            return DECIMAL;
        }
        if ("datetime".equals(type)) {
            return DATETIME;
        }
        if ("boolean".equals(type)) {
            return BOOLEAN;
        }
        if ("date".equals(type)) {
            return DATE;
        }
        if ("time".equals(type)) {
            return TIME;
        }
        if ("long".equals(type)) {
            return LONG;
        }
        if ("ENUM".equals(type)) {
            return STRING;
        }
        if ("string2".equals(type)) {
            return STRING2;
        }
        if ("double".equals(type)) {
            return DOUBLE;
        }
        return UNKNOWN;
    }
}

