/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.dt;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kd.ai.gai.flow.dt.DataType;

public final class TypedSet
implements Set<Object> {
    public static final String SEPERATOR = ",";
    private DataType type;
    private LinkedHashSet<Object> list;

    public TypedSet(DataType type) {
        this.type = type;
        this.list = new LinkedHashSet();
    }

    public DataType getType() {
        return this.type;
    }

    public Object sum() {
        if (this.size() == 0) {
            return null;
        }
        Object first = this.findOne();
        if (first == null) {
            return null;
        }
        if (first instanceof Integer) {
            return this.sumi();
        }
        if (first instanceof Long) {
            return this.suml();
        }
        if (first instanceof BigDecimal) {
            return this.sumd();
        }
        return this.concat();
    }

    private Object findOne() {
        for (Object e : this.list) {
            if (e == null) continue;
            return e;
        }
        return null;
    }

    public String concat() {
        return this.concat(SEPERATOR);
    }

    public String concat(String seperator) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (Object o : this) {
            if (i++ > 0) {
                sb.append(seperator);
            }
            if (o == null) continue;
            sb.append(o);
        }
        return sb.toString();
    }

    public Object max() {
        if (this.size() == 0) {
            return null;
        }
        Iterator it = this.list.iterator();
        Comparable c = null;
        while (it.hasNext() && (c = (Comparable)it.next()) == null) {
        }
        while (it.hasNext()) {
            Comparable o = (Comparable)it.next();
            if (o == null || o.compareTo(c) <= 0) continue;
            c = o;
        }
        return c;
    }

    public Object min() {
        if (this.size() == 0) {
            return null;
        }
        Iterator it = this.list.iterator();
        Comparable c = null;
        while (it.hasNext() && (c = (Comparable)it.next()) == null) {
        }
        while (it.hasNext()) {
            Comparable o = (Comparable)it.next();
            if (o == null || o.compareTo(c) >= 0) continue;
            c = o;
        }
        return c;
    }

    public int count() {
        if (this.size() == 0) {
            return 0;
        }
        int i = 0;
        for (Object o : this) {
            if (o == null) continue;
            ++i;
        }
        return i;
    }

    public int count(Object o) {
        if (this.size() == 0) {
            return 0;
        }
        o = this.type.narrow(o);
        int i = 0;
        for (Object e : this) {
            if (e == null || !e.equals(o)) continue;
            ++i;
        }
        return i;
    }

    public boolean includes(Collection<?> c) {
        if (c == null) {
            return true;
        }
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    public boolean includes(Object[] c) {
        if (c == null) {
            return true;
        }
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    public boolean exists(Object o) {
        return this.contains(o);
    }

    private BigDecimal sumd() {
        BigDecimal sum = new BigDecimal(0);
        for (Object o : this) {
            if (o == null) continue;
            sum = sum.add((BigDecimal)o);
        }
        return sum;
    }

    private int sumi() {
        int sum = 0;
        for (Object o : this) {
            if (o == null) continue;
            sum += ((Integer)o).intValue();
        }
        return sum;
    }

    private long suml() {
        long sum = 0L;
        for (Object o : this) {
            if (o == null) continue;
            sum += ((Long)o).longValue();
        }
        return sum;
    }

    @Override
    public boolean add(Object o) {
        o = this.type.narrow(o);
        this.list.add(o);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Object> c) {
        for (Object object : c) {
            this.add(object);
        }
        return true;
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public boolean contains(Object o) {
        o = this.type.narrow(o);
        return this.list.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator<Object> iterator() {
        return Collections.unmodifiableSet(this.list).iterator();
    }

    @Override
    public boolean remove(Object o) {
        o = this.type.narrow(o);
        return this.list.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        for (Object o : c) {
            this.remove(o);
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        ArrayList<Object> list = new ArrayList<Object>(c.size());
        for (Object o : c) {
            list.add(this.type.narrow(o));
        }
        return this.list.retainAll(list);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return this.list.toArray(array);
    }

    public String toString() {
        return this.list.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != TypedSet.class) {
            return false;
        }
        TypedSet o = (TypedSet)obj;
        if (!this.type.equals(o.type)) {
            return false;
        }
        LinkedHashSet<Object> lb = o.list;
        LinkedHashSet<Object> la = this.list;
        if (la.size() != lb.size()) {
            return false;
        }
        for (Object e : la) {
            if (lb.contains(e)) continue;
            return false;
        }
        return true;
    }
}

