/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.dt.i;

import java.util.Map;
import kd.ai.gai.flow.dt.D;
import kd.ai.gai.flow.dt.i.AbstractSimpleDataType;
import kd.ai.gai.flow.dt.i.Hex;
import kd.ai.gai.flow.misc.Json;

public final class StringType
extends AbstractSimpleDataType {
    private int max_length;
    private boolean is_unicode;

    public StringType(int max_length, boolean is_unicode) {
        this.max_length = max_length;
        this.is_unicode = is_unicode;
    }

    @Override
    public Object narrow(Object value) {
        if (value == null) {
            return null;
        }
        if (" ".equals(value)) {
            return " ";
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? "Y" : "N";
        }
        if (value instanceof byte[]) {
            return Hex.encode((byte[])value);
        }
        if (value instanceof Map) {
            Map m = (Map)value;
            String s = D.s(m.get("zh_CN"));
            if (s == null) {
                s = D.s(m.get("zh_TW"));
            }
            if (s == null) {
                s = D.s(m.get("en_US"));
            }
            return s == null ? Json.toString(m) : s;
        }
        String s = value.toString().trim();
        return s.length() == 0 ? null : s;
    }

    public boolean isUnicode() {
        return this.is_unicode;
    }

    public int getMaxLength() {
        return this.max_length;
    }

    public String toString() {
        if (this.is_unicode) {
            return this.max_length <= 0 ? "nclob" : "nvarchar(" + this.max_length + ")";
        }
        return this.max_length <= 0 ? "clob" : "varchar(" + this.max_length + ")";
    }
}

