/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.err;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import kd.ai.gai.flow.data.SingletonContainer;
import kd.ai.gai.flow.err.CodingError;
import kd.ai.gai.flow.err.ResourceBundle;

class Util {
    private static SingletonContainer<ResourceBundle.Entry, String> errorCodes = new SingletonContainer<ResourceBundle.Entry, String>(new SingletonContainer.Factory<ResourceBundle.Entry, String>(){

        @Override
        public String create(ResourceBundle.Entry err) {
            Class<? extends ResourceBundle> bundle = err.getErrorBundle();
            String code = (String)((Map)errorBundles.get(bundle)).get(err);
            if (code != null) {
                return code;
            }
            throw CodingError.ERROR_ENTRY_NOT_FOUND.create(bundle.getName(), err.getMessage());
        }
    });
    private static SingletonContainer<Class<?>, Map<ResourceBundle.Entry, String>> errorBundles = new SingletonContainer(new SingletonContainer.Factory<Class<?>, Map<ResourceBundle.Entry, String>>(){

        @Override
        public Map<ResourceBundle.Entry, String> create(Class<?> errorBundle) {
            Field[] fields = errorBundle.getFields();
            HashMap<ResourceBundle.Entry, String> map = new HashMap<ResourceBundle.Entry, String>(fields.length);
            String bundle = errorBundle.getSimpleName();
            for (Field field : fields) {
                int m = field.getModifiers();
                if (!Modifier.isPublic(m) || !Modifier.isStatic(m) || !ResourceBundle.Entry.class.isAssignableFrom(field.getType())) continue;
                try {
                    ResourceBundle.Entry e = (ResourceBundle.Entry)field.get(null);
                    map.put(e, field.getName() + "@" + bundle);
                }
                catch (Exception err) {
                    throw CodingError.INVALID_ERROR_BUNDLE.create(err, errorBundle.getName());
                }
            }
            return map;
        }
    });

    Util() {
    }

    static String transfer(ResourceBundle.Entry e, String ... params) {
        return String.format(e.getMessage(), params);
    }

    static String getCode(ResourceBundle.Entry e) {
        String code = errorCodes.get(e);
        return code;
    }
}

