/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.flow.core.i.arithmetic;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kd.ai.gai.flow.flow.core.i.arithmetic.Edge;
import kd.ai.gai.flow.flow.core.i.arithmetic.Vertex;
import kd.ai.gai.flow.flow.core.i.model.FlowImpl;
import kd.ai.gai.flow.flow.core.i.model.NodeImpl;
import kd.ai.gai.flow.flow.core.i.model.TransitionImpl;

public class Graph {
    private LinkedHashMap<String, Vertex> nodes = new LinkedHashMap();
    private ArrayList<Vertex> starts;

    public Graph(NodeImpl parent) {
        this.init(parent);
        this.wfs();
        this.bwfs();
        while (this.dfs() != null) {
        }
        this.dfs2();
        this.updateFlow(parent);
    }

    private void updateFlow(NodeImpl parent) {
        FlowImpl flow = parent.getFlow();
        HashSet<String> backwards = new HashSet<String>();
        for (Vertex v : this.nodes.values()) {
            backwards.clear();
            for (Edge e : v.outGoing()) {
                if (!e.isBackward()) continue;
                backwards.add(e.getTo().name());
            }
            for (TransitionImpl t : flow.getNode(v.name()).getOutGoing()) {
                if (!backwards.contains(t.getTarget().getId())) continue;
                t.setBackward();
            }
        }
    }

    public boolean reach(String from, String to) {
        boolean[] visited = new boolean[this.nodes.size()];
        Vertex start = this.nodes.get(from);
        Vertex end = this.nodes.get(to);
        return this.reach(start, end, visited);
    }

    public Set<String> findPriors(String to) {
        Vertex target = this.nodes.get(to);
        if (target == null) {
            return null;
        }
        HashSet<String> priors = new HashSet<String>(this.nodes.size());
        this.findPriors(target, priors);
        return priors;
    }

    public Set<String> findNexts(String from) {
        Vertex source = this.nodes.get(from);
        if (source == null) {
            return null;
        }
        HashSet<String> nexts = new HashSet<String>(this.nodes.size());
        this.findNexts(source, nexts);
        return nexts;
    }

    private void findNexts(Vertex source, HashSet<String> nexts) {
        for (Edge e : source.outGoing()) {
            Vertex to;
            if (e.isBackward() || !nexts.add((to = e.getTo()).name())) continue;
            this.findNexts(to, nexts);
        }
    }

    private void findPriors(Vertex target, HashSet<String> priors) {
        for (Edge e : target.inComing()) {
            Vertex from;
            if (e.isBackward() || !priors.add((from = e.getFrom()).name())) continue;
            this.findPriors(from, priors);
        }
    }

    public Set<String> findAllPriors(String target) {
        HashSet<String> priors = new HashSet<String>();
        this.findAllPriors(target, priors);
        return priors;
    }

    private void findAllPriors(String target, Set<String> priors) {
        Vertex to = this.nodes.get(target);
        for (Edge e : to.inComing()) {
            Vertex from = e.getFrom();
            String id = from.name();
            if (!priors.add(id)) continue;
            this.findAllPriors(id, priors);
        }
    }

    private boolean reach(Vertex start, Vertex end, boolean[] visited) {
        if (start == end) {
            return true;
        }
        visited[start.id()] = true;
        for (Edge e : start.outGoing()) {
            if (e.isBackward() || visited[e.getTo().id()] || !this.reach(e.getTo(), end, visited)) continue;
            return true;
        }
        return false;
    }

    private void init(NodeImpl parent) {
        List<NodeImpl> nodes = parent.getChildren();
        String[] names = new String[nodes.size()];
        boolean[] start = new boolean[nodes.size()];
        boolean[] end = new boolean[nodes.size()];
        String[][] trans = new String[nodes.size()][];
        for (int i = 0; i < nodes.size(); ++i) {
            String name;
            NodeImpl node = nodes.get(i);
            names[i] = name = node.getId();
            start[i] = node.isStart();
            end[i] = node.isEnd();
            List<TransitionImpl> transitions = node.getOutGoing();
            String[] outGoing = new String[transitions.size()];
            for (int j = 0; j < transitions.size(); ++j) {
                outGoing[j] = transitions.get(j).getTarget().getId();
            }
            trans[i] = outGoing;
        }
        this.init(names, start, end, trans);
    }

    private void init(String[] names, boolean[] start, boolean[] end, String[][] trans) {
        int i;
        for (i = 0; i < names.length; ++i) {
            this.nodes.put(names[i], new Vertex(i, names[i]));
        }
        for (int j = 0; j < trans.length; ++j) {
            String from = names[j];
            for (String to : trans[j]) {
                if (from.equals(to)) continue;
                new Edge(this.nodes.get(from), this.nodes.get(to));
            }
        }
        this.starts = new ArrayList(4);
        for (i = 0; i < names.length; ++i) {
            Vertex v = this.nodes.get(names[i]);
            v.setEnd(end[i]);
            v.setStart(start[i]);
            if (!v.isStart()) continue;
            this.starts.add(v);
        }
    }

    private Vertex dfs() {
        boolean[] visited = new boolean[this.nodes.size()];
        boolean[] cycle = new boolean[this.nodes.size()];
        Vertex[] stack = new Vertex[this.nodes.size()];
        boolean[] visited_stack = new boolean[this.nodes.size()];
        for (Vertex v : this.nodes.values()) {
            if (!v.isStart()) continue;
            this.dfs(v, visited, cycle, stack, visited_stack, 0);
        }
        return this.takeCycleVertex(cycle);
    }

    private Vertex takeCycleVertex(boolean[] cycle) {
        Vertex selected = null;
        for (Vertex v : this.nodes.values()) {
            int b;
            if (!cycle[v.id()]) continue;
            boolean hasExits = false;
            for (Edge e : v.outGoing()) {
                if (cycle[e.getTo().id()]) continue;
                hasExits = true;
            }
            if (!hasExits) continue;
            if (selected == null) {
                selected = v;
                continue;
            }
            int a = v.getDistanceFromStart();
            if (a <= (b = selected.getDistanceFromStart()) && (a != b || v.getDistanceToEnd() >= selected.getDistanceToEnd())) continue;
            selected = v;
        }
        if (selected != null) {
            for (Edge e : selected.outGoing()) {
                if (!cycle[e.getTo().id()]) continue;
                e.setBackward();
            }
        }
        return selected;
    }

    private void dfs(Vertex v, boolean[] visited, boolean[] cycle, Vertex[] stack, boolean[] visited_stack, int depth) {
        if (visited[v.id()]) {
            if (visited_stack[v.id()]) {
                for (int i = depth - 1; i >= 0; --i) {
                    cycle[stack[i].id()] = true;
                    if (stack[i] == v) break;
                }
            }
            return;
        }
        visited_stack[v.id()] = true;
        visited[v.id()] = true;
        stack[depth++] = v;
        for (Edge e : v.outGoing()) {
            if (e.isBackward()) continue;
            Vertex to = e.getTo();
            this.dfs(to, visited, cycle, stack, visited_stack, depth);
            if (!cycle[to.id()]) continue;
            cycle[v.id()] = true;
        }
        visited_stack[v.id()] = false;
    }

    private void wfs() {
        boolean[] visited = new boolean[this.nodes.size()];
        LinkedList<Vertex> queue = new LinkedList<Vertex>();
        for (Vertex v : this.nodes.values()) {
            if (!v.isStart()) continue;
            v.setDistanceFromStart(0);
            queue.add(v);
            visited[v.id()] = true;
        }
        while (queue.size() > 0) {
            Vertex v = (Vertex)queue.removeFirst();
            int distance = v.getDistanceFromStart() + 1;
            for (Edge e : v.outGoing()) {
                Vertex to = e.getTo();
                if (visited[to.id()]) continue;
                visited[to.id()] = true;
                to.setDistanceFromStart(distance);
                queue.addLast(to);
            }
        }
    }

    private void bwfs() {
        boolean[] visited = new boolean[this.nodes.size()];
        LinkedList<Vertex> queue = new LinkedList<Vertex>();
        for (Vertex v : this.nodes.values()) {
            if (!v.isEnd()) continue;
            v.setDistanceToEnd(0);
            queue.add(v);
            visited[v.id()] = true;
        }
        while (queue.size() > 0) {
            Vertex v = (Vertex)queue.removeFirst();
            int distance = v.getDistanceToEnd() + 1;
            for (Edge e : v.inComing()) {
                Vertex from = e.getFrom();
                if (visited[from.id()]) continue;
                visited[from.id()] = true;
                from.setDistanceToEnd(distance);
                queue.addLast(from);
            }
        }
    }

    public String toString() {
        return this.nodes.values().toString();
    }

    private void dfs2() {
        boolean[] visited = new boolean[this.nodes.size()];
        boolean[] forward = new boolean[this.nodes.size()];
        HashSet<Vertex> v_stack = new HashSet<Vertex>();
        HashSet<Edge> e_stack = new HashSet<Edge>();
        for (Vertex v : this.starts) {
            this.dfs2(v, visited, forward, v_stack, e_stack);
        }
    }

    private void dfs2(Vertex v, boolean[] visited, boolean[] forward, HashSet<Vertex> v_stack, HashSet<Edge> e_stack) {
        int index = v.id();
        this.checkEnd(v, visited, forward, index);
        if (visited[index]) {
            this.scanVisitedPath(v, forward, v_stack, e_stack, index);
            return;
        }
        visited[index] = true;
        v_stack.add(v);
        for (Edge e : v.outGoing()) {
            e_stack.add(e);
            this.dfs2(e.getTo(), visited, forward, v_stack, e_stack);
            e_stack.remove(e);
        }
        v_stack.remove(v);
    }

    private void scanVisitedPath(Vertex v, boolean[] forward, HashSet<Vertex> v_stack, HashSet<Edge> e_stack, int index) {
        if (!v_stack.contains(v) && forward[index]) {
            for (Vertex s : v_stack) {
                forward[s.id()] = true;
            }
            for (Edge e : e_stack) {
                e.setNotBackward();
            }
        }
    }

    private void checkEnd(Vertex v, boolean[] visited, boolean[] forward, int index) {
        if (v.isEnd()) {
            visited[index] = true;
            forward[index] = true;
        }
    }

    public List<String> wfsVisit() {
        ArrayList<String> list = new ArrayList<String>(this.nodes.size());
        LinkedList<Vertex> queue = new LinkedList<Vertex>();
        for (Vertex v : this.nodes.values()) {
            if (!v.isStart()) continue;
            queue.add(v);
        }
        boolean[] visited = new boolean[this.nodes.size()];
        while (!queue.isEmpty()) {
            Vertex v;
            v = (Vertex)queue.removeFirst();
            if (visited[v.id()]) continue;
            visited[v.id()] = true;
            list.add(v.name());
            for (Edge e : v.outGoing()) {
                queue.add(e.getTo());
            }
        }
        return list;
    }
}

