/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.flow.core.i.builder;

import java.util.List;
import kd.ai.gai.flow.connector.server.TaskExecutor;
import kd.ai.gai.flow.dt.DataType;
import kd.ai.gai.flow.flow.core.Event;
import kd.ai.gai.flow.flow.core.Node;
import kd.ai.gai.flow.flow.core.NodeBuilder;
import kd.ai.gai.flow.flow.core.VariableBuilder;
import kd.ai.gai.flow.flow.core.VariableMapping;
import kd.ai.gai.flow.flow.core.i.builder.AbstractBuilder;
import kd.ai.gai.flow.flow.core.i.builder.FlowBuilderImpl;
import kd.ai.gai.flow.flow.core.i.builder.VariableBuilderImpl;
import kd.ai.gai.flow.flow.core.i.c.Command;
import kd.ai.gai.flow.flow.core.i.c.app.InvokeListener;
import kd.ai.gai.flow.flow.core.i.model.FlowImpl;
import kd.ai.gai.flow.flow.core.i.model.NodeImpl;
import kd.ai.gai.flow.flow.core.i.model.Pattern;
import kd.ai.gai.flow.flow.core.i.model.VariableImpl;
import kd.ai.gai.flow.flow.core.i.pattern.AsyncBeginPattern;
import kd.ai.gai.flow.flow.core.i.pattern.AsyncEndPattern;
import kd.ai.gai.flow.flow.core.i.pattern.Biz;
import kd.ai.gai.flow.flow.core.i.pattern.CancelChildren;
import kd.ai.gai.flow.flow.core.i.pattern.ChildrenMultiInstance;
import kd.ai.gai.flow.flow.core.i.pattern.DeferredChoice;
import kd.ai.gai.flow.flow.core.i.pattern.ExecuteInAdvance;
import kd.ai.gai.flow.flow.core.i.pattern.ExitExclusive;
import kd.ai.gai.flow.flow.core.i.pattern.MultiChoice;
import kd.ai.gai.flow.flow.core.i.pattern.ParallelSplit;
import kd.ai.gai.flow.flow.core.i.pattern.SmartMerge;
import kd.ai.gai.flow.flow.core.i.pattern.SubFlow;
import kd.ai.gai.flow.flow.core.i.pattern.SyncMerge;
import kd.ai.gai.flow.flow.core.i.pattern.XorMerge;
import kd.ai.gai.flow.flow.core.plugin.Application;
import kd.ai.gai.flow.flow.core.plugin.Callback;
import kd.ai.gai.flow.flow.core.plugin.Condition;
import kd.ai.gai.flow.flow.core.plugin.Listener;
import kd.ai.gai.flow.flow.core.plugin.NodeExecutionSync;
import kd.ai.gai.flow.flow.core.plugin.SubFlowLoader;

public final class NodeBuilderImpl
extends AbstractBuilder<NodeImpl>
implements NodeBuilder {
    private Application app;
    private Callback callback;

    NodeBuilderImpl(NodeImpl impl, FlowBuilderImpl flowBuilder) {
        super(impl, flowBuilder);
    }

    @Override
    public NodeBuilder node(String id, String title) {
        NodeImpl node = new NodeImpl((NodeImpl)this.getImpl(), id, title);
        return new NodeBuilderImpl(node, this.getFlowBuilder());
    }

    @Override
    public VariableBuilder variable(String id, String name, String title, DataType type) {
        NodeImpl node = (NodeImpl)this.getImpl();
        VariableImpl var = node.addVariable(id, title, name, type);
        return new VariableBuilderImpl(var, this.getFlowBuilder());
    }

    @Override
    public VariableBuilder getVariable(String name) {
        NodeImpl node = (NodeImpl)this.getImpl();
        VariableImpl var = node.getVariable(name);
        if (var == null) {
            var = ((FlowImpl)this.getFlowBuilder().getImpl()).getVariable(name);
        }
        return var == null ? null : new VariableBuilderImpl(var, this.getFlowBuilder());
    }

    @Override
    public boolean isEnd() {
        return ((NodeImpl)this.getImpl()).isEnd();
    }

    @Override
    public boolean isStart() {
        return ((NodeImpl)this.getImpl()).isStart();
    }

    @Override
    public boolean hasInComings() {
        return ((NodeImpl)this.getImpl()).getInComing().size() > 0;
    }

    @Override
    public int inComingsCount() {
        return ((NodeImpl)this.getImpl()).getInComing().size();
    }

    @Override
    public boolean hasOutGoings() {
        return ((NodeImpl)this.getImpl()).getOutGoing().size() > 0;
    }

    @Override
    public int outGoingsCount() {
        return ((NodeImpl)this.getImpl()).getOutGoing().size();
    }

    @Override
    public void biz(Application app) {
        this.biz(app, null);
    }

    @Override
    public void biz(Application app, Callback callback) {
        ((NodeImpl)this.getImpl()).addPattern(new Biz(app, callback));
        this.app = app;
        this.callback = callback;
    }

    @Override
    public void setSynchronizer(NodeExecutionSync synchronizer) {
        ((NodeImpl)this.getImpl()).setSynchronizer(synchronizer);
    }

    @Override
    public boolean exists(Pattern pattern) {
        return ((NodeImpl)this.getImpl()).exists(pattern);
    }

    @Override
    public void andSplit() {
        ((NodeImpl)this.getImpl()).addPattern(ParallelSplit.PATTERN);
    }

    @Override
    public void multiChoice() {
        ((NodeImpl)this.getImpl()).addPattern(MultiChoice.PATTERN);
    }

    @Override
    public void deferredChoice() {
        ((NodeImpl)this.getImpl()).addPattern(DeferredChoice.PATTERN);
    }

    @Override
    public void childrenMultiInstance(String splitVar, String[] params, String[] returns) {
        NodeImpl node = (NodeImpl)this.getImpl();
        ChildrenMultiInstance p = new ChildrenMultiInstance(node, splitVar, params, returns);
        node.addPattern(p);
    }

    @Override
    public void childrenMultiInstance(String splitVar, String innerSplitVar, String[] params, String[] returns) {
        NodeImpl node = (NodeImpl)this.getImpl();
        ChildrenMultiInstance p = new ChildrenMultiInstance(node, splitVar, innerSplitVar, params, returns);
        node.addPattern(p);
    }

    @Override
    public void cancelChildren(Condition when, String ... vars) {
        CancelChildren p = new CancelChildren(when, vars);
        ((NodeImpl)this.getImpl()).addPattern(p);
    }

    @Override
    public void exitExclusive() {
        ((NodeImpl)this.getImpl()).addPattern(ExitExclusive.PATTERN);
    }

    @Override
    public void andMerge() {
        ((NodeImpl)this.getImpl()).addPattern(SyncMerge.PATTERN);
    }

    @Override
    public void smartMerge() {
        ((NodeImpl)this.getImpl()).addPattern(SmartMerge.PATTERN);
    }

    @Override
    public void exaMerge() {
        ((NodeImpl)this.getImpl()).addPattern(ExecuteInAdvance.PATTERN);
    }

    @Override
    public void xorMerge() {
        ((NodeImpl)this.getImpl()).addPattern(XorMerge.PATTERN);
    }

    @Override
    public void listener(Event e, Listener listener) {
        int i = this.getFlowBuilder().register(listener);
        int label = e.getAddress() + i + 250000;
        InvokeListener cmd = new InvokeListener(label, listener);
        ((NodeImpl)this.getImpl()).insert(cmd);
    }

    @Override
    public void call(SubFlowLoader loader, String[] params, String[] returns) {
        SubFlow p = new SubFlow(loader, params, returns);
        ((NodeImpl)this.getImpl()).addPattern(p);
    }

    @Override
    public void asEnd() {
        ((NodeImpl)this.getImpl()).setEnd(true);
    }

    @Override
    public void asStart() {
        ((NodeImpl)this.getImpl()).setStart(true);
    }

    @Override
    public Application getApplication() {
        return this.app;
    }

    @Override
    public Callback getCallback() {
        return this.callback;
    }

    @Override
    public Node end() {
        Node node = (Node)this.getImpl();
        super.release();
        return node;
    }

    @Override
    public NodeBuilder[] children() {
        List<NodeImpl> list = ((NodeImpl)this.getImpl()).getChildren();
        NodeBuilder[] nodes = new NodeBuilder[list.size()];
        int index = -1;
        for (NodeImpl node : list) {
            nodes[++index] = new NodeBuilderImpl(node, this.getFlowBuilder());
        }
        return nodes;
    }

    @Override
    public void insertCommand(Command i) {
        ((NodeImpl)this.getImpl()).insert(i);
    }

    @Override
    public void asyncBegin(TaskExecutor e, String[] inputVars, String[] outputVars) {
        ((NodeImpl)this.getImpl()).addPattern(new AsyncBeginPattern(e, inputVars, outputVars));
    }

    @Override
    public void asyncBegin(TaskExecutor e, VariableMapping arraySplitVar, String[] otherInputVars, VariableMapping arrayOutputVar, int maxThreads) {
        this.asyncBegin(e, arraySplitVar, otherInputVars, new VariableMapping[]{arrayOutputVar}, maxThreads);
    }

    @Override
    public void asyncBegin(TaskExecutor e, VariableMapping arraySplitVar, String[] otherInputVars, VariableMapping[] arrayOutputVars, int maxThreads) {
        ((NodeImpl)this.getImpl()).addPattern(new AsyncBeginPattern(e, arraySplitVar, otherInputVars, arrayOutputVars, maxThreads));
    }

    @Override
    public void asyncEnd() {
        ((NodeImpl)this.getImpl()).addPattern(new AsyncEndPattern());
    }
}

