/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.flow.core.i.c.app;

import java.util.Collection;
import kd.ai.gai.dataentity.resource.ResManager;
import kd.ai.gai.flow.debugger.DebuggerAction;
import kd.ai.gai.flow.dt.DataType;
import kd.ai.gai.flow.flow.core.Logger;
import kd.ai.gai.flow.flow.core.i.c.Command;
import kd.ai.gai.flow.flow.core.i.c.DebuggerBreakpoint;
import kd.ai.gai.flow.flow.core.i.c.app.TraceUtil;
import kd.ai.gai.flow.flow.core.i.model.VariableImpl;
import kd.ai.gai.flow.flow.core.i.runtime.ExecutionImpl;
import kd.ai.gai.flow.flow.core.plugin.Application;
import kd.ai.gai.flow.misc.StringUtil;
import kd.ai.gai.flow.script.feature.op.compare.Equals;

public class InvokeApplication
extends Command
implements DebuggerBreakpoint,
DebuggerAction {
    private Application app;

    public InvokeApplication(Application app) {
        super(5000000);
        this.app = app;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int invoke(ExecutionImpl e) {
        VariableImpl[] vars = this.getVariables(e);
        Object[] values = this.backupVariables(e, vars);
        try {
            TraceUtil.setTag(e);
            this.app.invoke(e);
            int n = 1;
            return n;
        }
        catch (Throwable error) {
            e.getRuntime().pushError(error);
            e.bizFailed();
            int n = 0;
            return n;
        }
        finally {
            this.checkVariables(e, vars, values);
        }
    }

    private VariableImpl[] getVariables(ExecutionImpl e) {
        Collection<VariableImpl> list = e.getDefine().getAvailableVariables().values();
        VariableImpl[] vars = list.toArray(new VariableImpl[list.size()]);
        return vars;
    }

    private void checkVariables(ExecutionImpl e, VariableImpl[] vars, Object[] values) {
        Logger logger = e.getRuntime().getFlow().getLogger();
        if (!this.needsVariableLog(e, logger)) {
            return;
        }
        for (int i = 0; i < vars.length; ++i) {
            Object original = values[i];
            VariableImpl v = vars[i];
            Object current = e.get(v);
            if (Equals.equals(original, current).booleanValue()) continue;
            DataType type = v.getType();
            String text = String.format(ResManager.loadKDString("\u53d8\u91cf\uff08%s\uff09\u7684\u5185\u5bb9\u6539\u53d8\u4e86\u3002", "InvokeApplication_3", "isc-iscb-util", new Object[0]), v.getName()) + "\r\n" + String.format(ResManager.loadKDString("\u65b0\u503c\uff1a%s", "InvokeApplication_4", "isc-iscb-util", new Object[0]), StringUtil.trim(type.forJson(current), 8000)) + "\r\n" + String.format(ResManager.loadKDString("\u539f\u503c\uff1a%s", "InvokeApplication_5", "isc-iscb-util", new Object[0]), StringUtil.trim(type.forJson(original), 8000));
            logger.info(e, text);
        }
    }

    private Object[] backupVariables(ExecutionImpl e, VariableImpl[] vars) {
        Logger logger = e.getRuntime().getFlow().getLogger();
        if (!this.needsVariableLog(e, logger)) {
            return null;
        }
        Object[] values = new Object[vars.length];
        for (int i = 0; i < vars.length; ++i) {
            VariableImpl v = vars[i];
            values[i] = e.get(v);
        }
        return values;
    }

    private boolean needsVariableLog(ExecutionImpl e, Logger logger) {
        return logger != null && e.getRuntime().getLoggerLevel() == Logger.Level.INFO;
    }

    @Override
    public String toString() {
        String name = this.app.toString();
        if (name.startsWith(this.app.getClass().getName())) {
            name = this.app.getClass().getSimpleName();
        }
        return name;
    }

    @Override
    public void onAttachBreakpoint() {
        if (this.app instanceof DebuggerAction) {
            ((DebuggerAction)((Object)this.app)).onAttachBreakpoint();
        }
    }

    @Override
    public void onDetachBreakpoint() {
        if (this.app instanceof DebuggerAction) {
            ((DebuggerAction)((Object)this.app)).onDetachBreakpoint();
        }
    }
}

