/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.flow.core.i.c.async;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kd.ai.gai.flow.connector.server.TaskExecutor;
import kd.ai.gai.flow.data.SimpleQueue;
import kd.ai.gai.flow.dt.D;
import kd.ai.gai.flow.flow.core.FlowTrace;
import kd.ai.gai.flow.flow.core.i.c.Command;
import kd.ai.gai.flow.flow.core.i.c.async.AsyncActor;
import kd.ai.gai.flow.flow.core.i.c.async.AsyncActorThread;
import kd.ai.gai.flow.flow.core.i.c.async.AsyncUtil;
import kd.ai.gai.flow.flow.core.i.model.AbstractExecutable;
import kd.ai.gai.flow.flow.core.i.model.FlowImpl;
import kd.ai.gai.flow.flow.core.i.model.NodeImpl;
import kd.ai.gai.flow.flow.core.i.model.VariableImpl;
import kd.ai.gai.flow.flow.core.i.model.VariableMappingX;
import kd.ai.gai.flow.flow.core.i.runtime.ExecutionImpl;
import kd.ai.gai.flow.flow.core.i.runtime.RuntimeImpl;
import kd.ai.gai.flow.script.feature.tool.data.DeepClone;

public class AsyncBegin
extends Command {
    private final TaskExecutor executor;
    private final VariableMappingX arraySplitVar;
    private final VariableImpl[] inputVars;
    private final NodeImpl asyncEndNode;
    private final int maxThreads;

    public AsyncBegin(TaskExecutor executor, VariableMappingX arraySplitVar, VariableImpl[] inputVars, NodeImpl asyncEndNode, int maxThreads) {
        super(3999999);
        this.executor = executor;
        this.arraySplitVar = arraySplitVar;
        this.inputVars = inputVars;
        this.asyncEndNode = asyncEndNode;
        this.maxThreads = Math.max(2, maxThreads);
    }

    @Override
    public int invoke(ExecutionImpl asyncBegin) {
        List<RuntimeImpl> threads = this.createAsyncThreads(asyncBegin);
        ExecutionImpl asyncEnd = this.createAsyncEnd(asyncBegin);
        List<AsyncActor> actors = this.prepareAsyncActors(threads, asyncBegin, asyncEnd);
        this.submitAsyncActors(actors);
        return 0;
    }

    private void submitAsyncActors(List<AsyncActor> actors) {
        if (this.maxThreads > actors.size()) {
            for (AsyncActor actor : actors) {
                this.executor.execute(actor);
            }
        } else {
            SimpleQueue<AsyncActor> queue = new SimpleQueue<AsyncActor>(actors);
            for (int i = 1; i < this.maxThreads; ++i) {
                this.executor.execute(new AsyncActorThread(queue));
            }
        }
    }

    private List<AsyncActor> prepareAsyncActors(List<RuntimeImpl> threads, ExecutionImpl asyncBegin, ExecutionImpl asyncEnd) {
        ArrayList<AsyncActor> actors = new ArrayList<AsyncActor>(threads.size());
        for (RuntimeImpl thread : threads) {
            asyncBegin.getMemory().registerAsyncThread(thread);
            actors.add(new AsyncActor(thread));
        }
        AsyncUtil.setActors(asyncEnd, actors);
        return actors;
    }

    private ExecutionImpl createAsyncEnd(ExecutionImpl asyncBegin) {
        if (this.asyncEndNode == asyncBegin.getDefine()) {
            asyncBegin.seek(19999001);
            asyncBegin.getRuntime().pushLowPriority(asyncBegin);
            return asyncBegin;
        }
        ExecutionImpl asyncEnd = new ExecutionImpl(asyncBegin.getParent(), this.asyncEndNode, asyncBegin.getMemory());
        asyncEnd.setPrior(asyncBegin.getId(), asyncBegin.getDefine().getId(), null);
        asyncBegin.stop();
        asyncBegin.getRuntime().pushLowPriority(asyncEnd);
        return asyncEnd;
    }

    private List<RuntimeImpl> createAsyncThreads(ExecutionImpl asyncBegin) {
        if (this.arraySplitVar == null) {
            RuntimeImpl thread = this.createAsyncThread(asyncBegin, 1);
            return D.asList(thread);
        }
        VariableImpl arrayVariable = this.arraySplitVar.getArrayVariable();
        Collection values = (Collection)asyncBegin.get(arrayVariable);
        if (values == null) {
            return Collections.emptyList();
        }
        VariableImpl elementVariable = this.arraySplitVar.getElementVariable();
        ArrayList<RuntimeImpl> threads = new ArrayList<RuntimeImpl>(values.size());
        int seq = 0;
        for (Object value : values) {
            RuntimeImpl thread = this.createAsyncThread(asyncBegin, ++seq);
            thread.set(elementVariable, value);
            threads.add(thread);
        }
        return threads;
    }

    private RuntimeImpl createAsyncThread(ExecutionImpl asyncBegin, int seq) {
        AbstractExecutable asyncBeginNode = asyncBegin.getDefine();
        String id = seq + "/" + asyncBeginNode.getId();
        FlowImpl flow = asyncBeginNode.getFlow();
        RuntimeImpl thread = new RuntimeImpl(flow, id);
        AsyncUtil.setAsync(thread, this.asyncEndNode);
        thread.setStartupX(asyncBeginNode.getId());
        FlowTrace flowTrace = asyncBegin.getRuntime().getFlowTrace();
        thread.setFlowTrace(flowTrace.clone());
        for (VariableImpl var : this.inputVars) {
            Object value = asyncBegin.get(var);
            Object cloned = DeepClone.clone(value);
            thread.set(var, cloned);
        }
        return thread;
    }
}

