/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.flow.core.i.c.async;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.ai.gai.flow.dt.D;
import kd.ai.gai.flow.flow.core.AsyncThreadsFailedException;
import kd.ai.gai.flow.flow.core.i.c.Command;
import kd.ai.gai.flow.flow.core.i.c.async.AsyncActor;
import kd.ai.gai.flow.flow.core.i.c.async.AsyncUtil;
import kd.ai.gai.flow.flow.core.i.model.FlowImpl;
import kd.ai.gai.flow.flow.core.i.model.VariableImpl;
import kd.ai.gai.flow.flow.core.i.model.VariableMappingX;
import kd.ai.gai.flow.flow.core.i.runtime.ExecutionImpl;
import kd.ai.gai.flow.flow.core.i.runtime.RuntimeImpl;

public class AsyncEnd
extends Command {
    private VariableImpl[] outputVars;
    private VariableMappingX[] arrayOutputVars;
    private Set<VariableImpl> usefulVars;

    public AsyncEnd(VariableImpl[] outputVars, VariableMappingX[] arrayOutputVars) {
        super(19999001);
        this.outputVars = outputVars;
        this.arrayOutputVars = arrayOutputVars;
        this.usefulVars = this.collectUsefulVars(outputVars, arrayOutputVars);
    }

    private Set<VariableImpl> collectUsefulVars(VariableImpl[] outputVars, VariableMappingX[] arrayOutputVars) {
        int length = AsyncEnd.getLength(outputVars) + AsyncEnd.getLength(arrayOutputVars);
        HashSet<VariableImpl> usefulVars = new HashSet<VariableImpl>(length);
        if (outputVars != null) {
            for (VariableImpl variableImpl : outputVars) {
                usefulVars.add(variableImpl);
            }
        }
        if (arrayOutputVars != null) {
            for (VariableMappingX variableMappingX : arrayOutputVars) {
                usefulVars.add(variableMappingX.getElementVariable());
            }
        }
        return usefulVars;
    }

    private static int getLength(Object[] array) {
        return array == null ? 0 : array.length;
    }

    @Override
    public int invoke(ExecutionImpl e) {
        if (AsyncUtil.isAsync(e)) {
            this.cleanUselessVariables(e);
            e.forceStop();
            return 0;
        }
        List<AsyncActor> actors = AsyncUtil.getActors(e);
        if (!this.actorsIsDone(e, actors)) {
            D.sleep(10L);
            e.getRuntime().pushLowPriority(e);
            return 0;
        }
        if (this.arrayOutputVars != null) {
            return this.outputMultiAsyncThreads(e, actors);
        }
        return this.outputSingleAsyncThread(e, actors);
    }

    private void cleanUselessVariables(ExecutionImpl e) {
        FlowImpl flow = e.getRuntime().getFlow();
        int j = flow.variableCount();
        for (int i = 0; i < j; ++i) {
            VariableImpl v = flow.getVariable(i);
            if (this.usefulVars.contains(v)) continue;
            e.getMemory().setAt(v, null);
        }
    }

    private boolean actorsIsDone(ExecutionImpl e, List<AsyncActor> actors) {
        for (AsyncActor actor : actors) {
            actor.run();
        }
        for (AsyncActor actor : actors) {
            if (actor.isDone()) continue;
            return false;
        }
        return true;
    }

    private int outputMultiAsyncThreads(ExecutionImpl e, List<AsyncActor> actors) {
        ArrayList<Throwable> errors = new ArrayList<Throwable>(actors.size());
        List<Object>[] values = this.prepareValuesArray(actors);
        this.collecOutputs(actors, errors, values);
        return this.handleOutputs(e, errors, values);
    }

    private int handleOutputs(ExecutionImpl e, List<Throwable> errors, List<Object>[] values) {
        for (int i = 0; i < values.length; ++i) {
            VariableImpl var = this.arrayOutputVars[i].getArrayVariable();
            e.set(var, values[i]);
        }
        if (errors.isEmpty()) {
            return 1;
        }
        e.bizFailed();
        e.getRuntime().pushError(this.wrap(errors));
        return 0;
    }

    private List<Object>[] prepareValuesArray(List<AsyncActor> actors) {
        List[] values = new List[this.arrayOutputVars.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = new ArrayList(actors.size());
        }
        return values;
    }

    private void collecOutputs(List<AsyncActor> actors, List<Throwable> errors, List<Object>[] values) {
        for (AsyncActor actor : actors) {
            Throwable error = actor.getError();
            if (error != null) {
                errors.add(error);
            }
            RuntimeImpl thread = actor.getThread();
            for (int i = 0; i < values.length; ++i) {
                VariableImpl var = this.arrayOutputVars[i].getElementVariable();
                Object value = thread.get(var);
                values[i].add(value);
            }
        }
    }

    private AsyncThreadsFailedException wrap(List<Throwable> errors) {
        AsyncThreadsFailedException error = new AsyncThreadsFailedException();
        for (Throwable t : errors) {
            error.addSuppressed(t);
        }
        return error;
    }

    private int outputSingleAsyncThread(ExecutionImpl e, List<AsyncActor> actors) {
        AsyncActor actor = actors.get(0);
        Throwable error = actor.getError();
        if (error != null) {
            e.bizFailed();
            e.getRuntime().pushError(error);
            return 0;
        }
        RuntimeImpl thread = actor.getThread();
        for (VariableImpl var : this.outputVars) {
            Object value = thread.get(var);
            e.set(var, value);
        }
        return 1;
    }
}

