/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.flow.core.i.c.async;

import java.util.ArrayList;
import java.util.List;
import kd.ai.gai.flow.dt.D;
import kd.ai.gai.flow.flow.core.Execution;
import kd.ai.gai.flow.flow.core.i.c.Command;
import kd.ai.gai.flow.flow.core.i.c.async.AsyncActor;
import kd.ai.gai.flow.flow.core.i.c.async.DisableErrorTransferOnAsyncEnd;
import kd.ai.gai.flow.flow.core.i.c.async.JumpAfterAsyncBegin;
import kd.ai.gai.flow.flow.core.i.c.async.JumpToAsyncEnd;
import kd.ai.gai.flow.flow.core.i.c.async.ResumeAsyncThread;
import kd.ai.gai.flow.flow.core.i.c.async.SuspendAsyncThread;
import kd.ai.gai.flow.flow.core.i.c.async.TerminateAsyncThread;
import kd.ai.gai.flow.flow.core.i.model.NodeImpl;
import kd.ai.gai.flow.flow.core.i.runtime.ExecutionImpl;
import kd.ai.gai.flow.flow.core.i.runtime.RuntimeImpl;

public class AsyncUtil {
    public static Command JUMP_TO_ASYNC_END_ON_MAIN = new JumpToAsyncEnd();
    public static Command JUMP_AFTER_ASYNC_BEGIN_ON_ASYNC = new JumpAfterAsyncBegin();
    public static Command DISABLE_ERROR_TRANSFER_ON_ASYNC = new DisableErrorTransferOnAsyncEnd();
    public static Command TERMINATE_ASYNC_THREAD = new TerminateAsyncThread();
    public static Command RESUME_ASYNC_THREAD = new ResumeAsyncThread();
    public static Command SUSPEND_ASYNC_THREAD = new SuspendAsyncThread();

    static boolean isAsync(Execution e) {
        return D.x(e.getRuntime().getProperty("IS_ASYNC"));
    }

    static void setAsync(RuntimeImpl runtime, NodeImpl ignoredAsyncEndNode) {
        runtime.setProperty("IS_ASYNC", true);
    }

    static void setActors(ExecutionImpl asyncEnd, List<AsyncActor> actors) {
        asyncEnd.setTransientProperty("asyncActors", actors);
        ArrayList<String> list = new ArrayList<String>(actors.size());
        for (AsyncActor actor : actors) {
            list.add(actor.getThread().getId());
        }
        asyncEnd.setProperty("async_threads", list);
    }

    static List<AsyncActor> getActors(ExecutionImpl asyncEnd) {
        ArrayList<AsyncActor> actors = (ArrayList<AsyncActor>)asyncEnd.getTransientProperty("asyncActors");
        if (actors != null) {
            return actors;
        }
        List list = (List)asyncEnd.getProperty("async_threads");
        if (list == null) {
            return null;
        }
        actors = new ArrayList<AsyncActor>(list.size());
        for (String threadId : list) {
            RuntimeImpl thread = asyncEnd.getMemory().getAsyncThread(threadId);
            actors.add(new AsyncActor(thread));
        }
        asyncEnd.setTransientProperty("asyncActors", actors);
        return actors;
    }

    public static void setDone(RuntimeImpl thread) {
        thread.setProperty("is_done", true);
    }

    public static boolean isDone(RuntimeImpl thread) {
        return D.x(thread.getProperty("is_done"));
    }
}

