/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.flow.core.i.c.composite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.ai.gai.flow.except.IscBizException;
import kd.ai.gai.flow.flow.core.i.c.Command;
import kd.ai.gai.flow.flow.core.i.c.DebuggerBreakpoint;
import kd.ai.gai.flow.flow.core.i.model.FlowImpl;
import kd.ai.gai.flow.flow.core.i.model.NodeImpl;
import kd.ai.gai.flow.flow.core.i.model.VariableImpl;
import kd.ai.gai.flow.flow.core.i.runtime.DataAreaImpl;
import kd.ai.gai.flow.flow.core.i.runtime.ExecutionImpl;
import kd.ai.gai.flow.flow.core.i.runtime.RuntimeImpl;

public class StartSubNodes4MultiInst
extends Command
implements DebuggerBreakpoint {
    private NodeImpl parent;
    private VariableImpl splitVar;
    private VariableImpl splitShadow;
    private VariableImpl[] paramVars;
    private VariableImpl[] returnVars;
    private VariableImpl countVar;

    public StartSubNodes4MultiInst(NodeImpl parent, VariableImpl splitVar, VariableImpl splitShadow, VariableImpl[] paramVars, VariableImpl[] returnVars, VariableImpl countVar) {
        super(10000000);
        this.parent = parent;
        this.splitVar = splitVar;
        this.countVar = countVar;
        this.splitShadow = splitShadow;
        this.paramVars = (VariableImpl[])paramVars.clone();
        this.returnVars = (VariableImpl[])returnVars.clone();
    }

    @Override
    public int invoke(ExecutionImpl e) {
        e.set(this.countVar, (Object)0);
        Collection splitValues = (Collection)e.getMemory().getAt(this.splitVar);
        this.createChildrenAsMultiInst(e, splitValues);
        this.clearReturnVars(e);
        return 1;
    }

    private void clearReturnVars(ExecutionImpl e) {
        for (VariableImpl v : this.returnVars) {
            e.clear(v);
        }
    }

    public void createChildrenAsMultiInst(ExecutionImpl e, Collection<?> splitValues) {
        this.checkInstanceCount(e, splitValues);
        RuntimeImpl runtime = e.getRuntime();
        int[] addresses = this.getParamAddresses();
        Object[] values = this.getParamValues(e);
        List<DataAreaImpl> mems = this.createSubMemories(e, addresses, values, splitValues);
        this.startSubNodes(e, runtime, mems);
    }

    private void checkInstanceCount(ExecutionImpl e, Collection<?> splitValues) {
        int count = splitValues.size();
        if (count == 0) {
            throw new IscBizException("Variable '" + this.countVar.getName() + "' is empty!");
        }
        e.set(this.countVar, (Object)(count += ((Integer)e.get(this.countVar)).intValue()));
    }

    private void startSubNodes(ExecutionImpl e, RuntimeImpl runtime, List<DataAreaImpl> memories) {
        for (DataAreaImpl mem : memories) {
            this.startSubNodes(e, this.parent, mem, runtime);
        }
    }

    private List<DataAreaImpl> createSubMemories(ExecutionImpl e, int[] addresses, Object[] values, Collection<?> list) {
        ArrayList<DataAreaImpl> memories = new ArrayList<DataAreaImpl>(list.size());
        FlowImpl flow = this.parent.getFlow();
        for (Object v : list) {
            values[this.paramVars.length] = v;
            DataAreaImpl mem = new DataAreaImpl(e, flow, addresses, values);
            memories.add(mem);
        }
        return memories;
    }

    private Object[] getParamValues(ExecutionImpl e) {
        Object[] values = new Object[this.paramVars.length + 2];
        for (int i = 0; i < this.paramVars.length; ++i) {
            values[i] = e.get(this.paramVars[i]);
        }
        values[this.paramVars.length + 1] = null;
        return values;
    }

    private int[] getParamAddresses() {
        int shadow;
        int[] addresses = new int[this.paramVars.length + 2];
        for (int i = 0; i < this.paramVars.length; ++i) {
            addresses[i] = this.paramVars[i].getAddress();
        }
        addresses[this.paramVars.length + 1] = this.splitVar.getAddress();
        addresses[this.paramVars.length] = shadow = this.splitShadow.getAddress();
        return addresses;
    }

    private void startSubNodes(ExecutionImpl e, NodeImpl parent, DataAreaImpl area, RuntimeImpl runtime) {
        for (NodeImpl child : parent.getChildren()) {
            if (!child.isStart()) continue;
            ExecutionImpl c = new ExecutionImpl(e, child, area);
            runtime.push(c);
        }
    }
}

