/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.flow.core.i.c.trans;

import java.util.ArrayList;
import java.util.List;
import kd.ai.gai.flow.dt.D;
import kd.ai.gai.flow.except.TaskCancelException;
import kd.ai.gai.flow.flow.core.Logger;
import kd.ai.gai.flow.flow.core.Transition;
import kd.ai.gai.flow.flow.core.i.c.Command;
import kd.ai.gai.flow.flow.core.i.c.trans.AbstractTransit;
import kd.ai.gai.flow.flow.core.i.c.trans.XorChoice;
import kd.ai.gai.flow.flow.core.i.model.NodeImpl;
import kd.ai.gai.flow.flow.core.i.model.TransitionImpl;
import kd.ai.gai.flow.flow.core.i.runtime.ExecutionImpl;
import kd.ai.gai.flow.flow.core.i.runtime.RuntimeImpl;

public class ErrorHandle
extends Command {
    private TransitionImpl other;
    private List<TransitionImpl> candidates = new ArrayList<TransitionImpl>();

    public ErrorHandle(NodeImpl node) {
        super(26000100);
        for (TransitionImpl tran : node.getOutGoing()) {
            if (tran.getType() != Transition.Type.ERROR) continue;
            if (tran.getCondition() != null) {
                this.candidates.add(tran);
                continue;
            }
            this.other = tran;
        }
    }

    @Override
    public int invoke(ExecutionImpl e) {
        RuntimeImpl runtime = e.getRuntime();
        Throwable error = runtime.getError();
        if (error instanceof TaskCancelException) {
            return 1;
        }
        List<TransitionImpl> targets = XorChoice.testConditions(e, this.candidates);
        if (targets.isEmpty() && D.isFatal(error)) {
            return 1;
        }
        if ((targets = XorChoice.handleOther(targets, this.other)) == null) {
            return 1;
        }
        this.saveErrorLog(e);
        AbstractTransit.transitNext(e, targets);
        e.getRuntime().popError();
        return 34000000;
    }

    private void saveErrorLog(ExecutionImpl e) {
        RuntimeImpl runtime = e.getRuntime();
        Throwable error = runtime.getError();
        Logger log = runtime.getFlow().getLogger();
        if (log != null && error != null) {
            log.warn(e, error);
        }
    }
}

