/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.flow.core.i.model;

import java.util.HashMap;
import java.util.Map;
import kd.ai.gai.dataentity.resource.ResManager;
import kd.ai.gai.flow.except.IscBizException;
import kd.ai.gai.flow.flow.core.Transition;
import kd.ai.gai.flow.flow.core.i.c.trans.BoomerangTarget;
import kd.ai.gai.flow.flow.core.i.c.trans.DynamicChoice;
import kd.ai.gai.flow.flow.core.i.c.trans.LazyChoice;
import kd.ai.gai.flow.flow.core.i.model.AbstractElement;
import kd.ai.gai.flow.flow.core.i.model.FlowImpl;
import kd.ai.gai.flow.flow.core.i.model.NodeImpl;
import kd.ai.gai.flow.flow.core.i.model.VariableImpl;
import kd.ai.gai.flow.flow.core.i.pattern.XorMerge;
import kd.ai.gai.flow.flow.core.i.runtime.DataAreaImpl;
import kd.ai.gai.flow.flow.core.plugin.Condition;

public class TransitionImpl
extends AbstractElement
implements Transition {
    private Transition.Type type;
    private String sourceId;
    private String targetId;
    private NodeImpl source;
    private NodeImpl target;
    private Map<String, String> assigns;
    private VariableImpl[] from;
    private VariableImpl[] to;
    private Condition condition;
    private boolean backward;
    private boolean rejected;
    private boolean agreed;
    private boolean boomerang = false;

    public TransitionImpl(FlowImpl flow, String id, String title, Transition.Type type, String source, String target) {
        super(flow, id, title);
        this.type = type;
        this.sourceId = source;
        this.targetId = target;
        this.bind();
    }

    private void bind() {
        this.source = this.getFlow().getNode(this.sourceId);
        this.target = this.getFlow().getNode(this.targetId);
        this.checkNodes();
        this.source.addOutGoing(this);
        this.target.addInComing(this);
    }

    private void checkNodes() {
        String link = ResManager.loadKDString("\u8fde\u63a5", "TransitionImpl_0", "isc-iscb-util", new Object[0]);
        link = this.getTitle() != null ? link + "\uff08" + this.getTitle() + "\uff09" : link + "\uff08" + this.getId() + "\uff09";
        if (this.source == null) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString("%1$s\u7684\u8d77\u59cb\u8282\u70b9\uff08%2$s\uff09\u5728\u6d41\u7a0b\u4e2d\u4e0d\u5b58\u5728\uff01", "TransitionImpl_7", "isc-iscb-util", new Object[0]), link, this.sourceId));
        }
        if (this.target == null) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString("%1$s\u8fde\u63a5\u7684\u76ee\u6807\u8282\u70b9\uff08%2$s\uff09\u5728\u6d41\u7a0b\u4e2d\u4e0d\u5b58\u5728\uff01", "TransitionImpl_8", "isc-iscb-util", new Object[0]), link, this.targetId));
        }
        if (this.source.isCompensation()) {
            throw new RuntimeException(String.format(ResManager.loadKDString("\u201c%1$s(%2$s)\u201d\u662f\u8865\u507f\u8282\u70b9\uff0c\u4e0d\u80fd\u4f5c\u4e3a\u8f6c\u79fb\u8fde\u7ebf\u7684\u8d77\u70b9\uff01", "TransitionImpl_9", "isc-iscb-util", new Object[0]), this.source.getTitle(), this.source.getId()));
        }
        if (this.source.getParent() != this.target.getParent()) {
            throw new RuntimeException(String.format(ResManager.loadKDString("\u201c%1$s(%2$s)\u201d\u4e0e%3$s(%4$s)\u4e0d\u5c5e\u4e8e\u540c\u4e00\u4e2a\u8282\u70b9\u5757\u3002", "TransitionImpl_10", "isc-iscb-util", new Object[0]), this.source.getTitle(), this.source.getId(), this.target.getTitle(), this.target.getId()));
        }
    }

    @Override
    public Transition.Type getType() {
        return this.type;
    }

    @Override
    public NodeImpl getSource() {
        return this.source;
    }

    @Override
    public NodeImpl getTarget() {
        return this.target;
    }

    @Override
    public boolean isBackward() {
        return this.backward;
    }

    public void setBackward() {
        this.backward = true;
        if (!this.agreed) {
            this.setRejected();
        }
    }

    @Override
    public boolean isRejected() {
        return this.rejected;
    }

    public void setRejected() {
        this.rejected = true;
    }

    public void setAgreed() {
        this.agreed = true;
    }

    @Override
    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        if (this.condition != null) {
            throw new IscBizException("Condition has set on '" + this.getId() + "'!");
        }
        this.condition = condition;
    }

    public void assign(String toVar, String fromVar) {
        if (this.assigns == null) {
            this.assigns = new HashMap<String, String>(8);
        }
        this.assigns.put(toVar, fromVar);
    }

    @Override
    void compile() {
        this.checkCompensation();
        this.checkParent();
        this.comileCondition();
        this.compileAssigns();
    }

    private void checkCompensation() {
        if (this.source.isCompensation()) {
            throw new IscBizException("Source node is for compensation!");
        }
    }

    private void checkParent() {
        if (this.source.getParent() != this.target.getParent()) {
            throw new IscBizException("Source and target don't exist in the same parent node!");
        }
    }

    private void comileCondition() {
        if (this.condition != null) {
            this.condition.compile(this.source);
        }
    }

    private void compileAssigns() {
        if (this.assigns == null || this.assigns.size() == 0) {
            return;
        }
        int i = 0;
        this.from = new VariableImpl[this.assigns.size()];
        this.to = new VariableImpl[this.assigns.size()];
        for (Map.Entry<String, String> assign : this.assigns.entrySet()) {
            VariableImpl from;
            String toVar = assign.getKey();
            String fromVar = assign.getValue();
            VariableImpl to = this.target.retrieveVariable(toVar);
            this.from[i] = from = this.source.retrieveVariable(fromVar);
            this.to[i] = to;
            ++i;
        }
        this.assigns = null;
    }

    public void transferData(DataAreaImpl mem) {
        if (this.from == null) {
            return;
        }
        int j = this.from.length;
        for (int i = 0; i < j; ++i) {
            Object v = mem.getAt(this.from[i]);
            mem.setAt(this.to[i], v);
        }
    }

    public void setBoomerang() {
        this.boomerang = true;
        this.target.addPattern(XorMerge.PATTERN);
        this.target.insert(DynamicChoice.INS);
        this.source.insert(BoomerangTarget.INS);
        this.source.insert(LazyChoice.CMD);
    }

    @Override
    public boolean isBoomerang() {
        return this.boomerang;
    }
}

