/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.flow.core.i.model;

import java.util.Map;
import kd.ai.gai.flow.dt.CollectionDataType;
import kd.ai.gai.flow.dt.DataType;
import kd.ai.gai.flow.except.IscBizException;
import kd.ai.gai.flow.flow.core.Variable;
import kd.ai.gai.flow.flow.core.i.c.common.End;
import kd.ai.gai.flow.flow.core.i.c.common.GotoDisposing;
import kd.ai.gai.flow.flow.core.i.c.common.Pause;
import kd.ai.gai.flow.flow.core.i.c.common.RestoreRecovery;
import kd.ai.gai.flow.flow.core.i.model.AbstractExecutable;
import kd.ai.gai.flow.flow.core.i.model.AbstractVariableScope;

public class VariableImpl
extends AbstractExecutable
implements Variable {
    private String name;
    private AbstractVariableScope parent;
    private DataType type;
    private int address;
    private Object initValue;
    private boolean is_transient;

    VariableImpl(String id, String title, String name, DataType type, AbstractVariableScope parent) {
        super(parent.getFlow(), id, title);
        this.name = name;
        this.type = type;
        this.parent = parent;
        this.address = parent.getFlow().variableCount() - 1;
    }

    public void setInitValue(Object initValue) {
        this.initValue = initValue;
    }

    public void setTransient(boolean isTransient) {
        this.is_transient = isTransient;
    }

    public void setType(DataType type) {
        if (this.type != null) {
            throw new IscBizException("Variable " + this.name + "'s data type has been set!");
        }
        this.type = type;
    }

    public int getAddress() {
        return this.address;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DataType getType() {
        return this.type;
    }

    @Override
    public Object getInitValue() {
        return this.initValue;
    }

    @Override
    public AbstractVariableScope getParent() {
        return this.parent;
    }

    @Override
    public boolean isTransient() {
        return this.is_transient;
    }

    @Override
    Map<String, VariableImpl> getOtherAvailableVariables() {
        return this.getParent().getAvailableVariables();
    }

    @Override
    void compile() {
        super.compile();
        this.insertDefault();
    }

    private void insertDefault() {
        if (this.getCommandCount() > 0) {
            this.insert(Pause.CMD_AFTER_SUSPENDED);
            this.insert(RestoreRecovery.CMD);
            this.insert(GotoDisposing.CMD);
            this.insert(End.CMD);
        }
    }

    @Override
    void dumpMicroProgram(StringBuilder sb) {
        sb.append("\r\n    ").append(this.getId()).append('\uff08').append(this.getTitle()).append('\uff1a').append(this.getName()).append('\uff09');
        if (!this.getFlow().equals(this.getParent())) {
            sb.append('@').append(this.getParent());
        }
        sb.append(": ");
        super.dumpMicroProgram(sb);
    }

    public boolean isArray() {
        return this.type instanceof CollectionDataType;
    }
}

