/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.flow.core.i.pattern;

import java.util.HashSet;
import java.util.Set;
import kd.ai.gai.dataentity.resource.ResManager;
import kd.ai.gai.flow.connector.server.TaskExecutor;
import kd.ai.gai.flow.except.IscBizException;
import kd.ai.gai.flow.flow.core.VariableMapping;
import kd.ai.gai.flow.flow.core.i.c.async.AsyncBegin;
import kd.ai.gai.flow.flow.core.i.c.async.AsyncEnd;
import kd.ai.gai.flow.flow.core.i.c.async.AsyncUtil;
import kd.ai.gai.flow.flow.core.i.model.NodeImpl;
import kd.ai.gai.flow.flow.core.i.model.Pattern;
import kd.ai.gai.flow.flow.core.i.model.TransitionImpl;
import kd.ai.gai.flow.flow.core.i.model.VariableImpl;
import kd.ai.gai.flow.flow.core.i.model.VariableMappingX;

public class AsyncBeginPattern
extends Pattern {
    private final TaskExecutor e;
    private final String[] inputVars;
    private final String[] outputVars;
    private final VariableMapping arraySplitVar;
    private final VariableMapping[] arrayOutputVars;
    private final int maxThreads;

    public AsyncBeginPattern(TaskExecutor e, String[] inputVars, String[] outputVars) {
        super(700, "ASYNC_BEGIN", "ASYNC_BEGIN", "CALL_CHILDREN");
        this.e = e;
        this.inputVars = inputVars;
        this.outputVars = outputVars;
        this.arrayOutputVars = null;
        this.arraySplitVar = null;
        this.maxThreads = 1;
    }

    public AsyncBeginPattern(TaskExecutor e, VariableMapping arraySplitVar, String[] otherInputVars, VariableMapping[] arrayOutputVars, int maxThreads) {
        super(700, "ASYNC_BEGIN", "ASYNC_BEGIN", "CALL_CHILDREN");
        this.e = e;
        this.arrayOutputVars = arrayOutputVars;
        this.arraySplitVar = arraySplitVar;
        this.inputVars = otherInputVars;
        this.maxThreads = maxThreads;
        this.outputVars = null;
    }

    @Override
    public void apply(NodeImpl node1) {
        NodeImpl asyncBeginNode = node1;
        this.validateAsyncBeginNode(asyncBeginNode);
        NodeImpl asyncEndNode = this.findEnd(asyncBeginNode);
        asyncBeginNode.insert(AsyncUtil.JUMP_AFTER_ASYNC_BEGIN_ON_ASYNC);
        VariableImpl[] inputVars = AsyncBeginPattern.prepareVariables(asyncBeginNode, this.inputVars);
        VariableMappingX arraySplitVar = AsyncBeginPattern.prepareArrayVariableMapping(asyncBeginNode, this.arraySplitVar);
        asyncBeginNode.insert(new AsyncBegin(this.e, arraySplitVar, inputVars, asyncEndNode, this.maxThreads));
        VariableImpl[] outputVars = AsyncBeginPattern.prepareVariables(asyncBeginNode, this.outputVars);
        if (asyncEndNode != asyncBeginNode) {
            asyncEndNode.insert(AsyncUtil.JUMP_TO_ASYNC_END_ON_MAIN);
        }
        VariableMappingX[] arrayOutputVars = AsyncBeginPattern.prepareArrayVariableMapping(asyncBeginNode, this.arrayOutputVars);
        asyncEndNode.insert(new AsyncEnd(outputVars, arrayOutputVars));
        asyncEndNode.insert(AsyncUtil.DISABLE_ERROR_TRANSFER_ON_ASYNC);
        asyncEndNode.insert(AsyncUtil.TERMINATE_ASYNC_THREAD);
        asyncEndNode.insert(AsyncUtil.RESUME_ASYNC_THREAD);
        asyncEndNode.insert(AsyncUtil.SUSPEND_ASYNC_THREAD);
    }

    private static VariableMappingX[] prepareArrayVariableMapping(NodeImpl node, VariableMapping[] arrayVarMappings) {
        if (arrayVarMappings == null) {
            return null;
        }
        VariableMappingX[] mappings = new VariableMappingX[arrayVarMappings.length];
        int j = arrayVarMappings.length;
        for (int i = 0; i < j; ++i) {
            mappings[i] = AsyncBeginPattern.prepareArrayVariableMapping(node, arrayVarMappings[i]);
        }
        return mappings;
    }

    private static VariableMappingX prepareArrayVariableMapping(NodeImpl node, VariableMapping arrayVarMapping) {
        if (arrayVarMapping == null) {
            return null;
        }
        VariableImpl arrayVar = node.retrieveVariable(arrayVarMapping.getArrayVariable());
        VariableImpl elementVar = node.retrieveVariable(arrayVarMapping.getElementVariable());
        return new VariableMappingX(arrayVar, elementVar);
    }

    private static VariableImpl[] prepareVariables(NodeImpl node, String[] vars) {
        if (vars == null || vars.length == 0) {
            return new VariableImpl[0];
        }
        VariableImpl[] outputVars = new VariableImpl[vars.length];
        for (int i = 0; i < vars.length; ++i) {
            outputVars[i] = node.retrieveVariable(vars[i]);
        }
        return outputVars;
    }

    private void validateAsyncBeginNode(NodeImpl node) {
        NodeImpl parent = node;
        while ((parent = parent.getParent()) != null) {
            if (parent.getPattern("ASYNC_BEGIN") == null) continue;
            String message = String.format(ResManager.loadKDString("\u8282\u70b9\u201c%1$s\u201d\u4e0e\u5176\u4e0a\u7ea7\u8282\u70b9\u201c%2$s\u201d\u90fd\u542f\u7528\u4e86\u5f02\u6b65\u5206\u652f\u7279\u6027\u3002", "AsyncBeginPattern_0", "isc-iscb-platform-core", new Object[0]), node, parent);
            throw new IscBizException(message);
        }
    }

    private NodeImpl findEnd(NodeImpl asyncBeginNode) {
        if (asyncBeginNode.getPattern("ASYNC_END") != null) {
            return asyncBeginNode;
        }
        HashSet<NodeImpl> visitedNext = new HashSet<NodeImpl>();
        NodeImpl asyncEndNode = this.findEnd(asyncBeginNode, visitedNext, null);
        if (asyncEndNode == null) {
            String message = String.format(ResManager.loadKDString("\u6ca1\u6709\u5b9a\u4e49\u5f02\u6b65\u5206\u652f\u7ec8\u70b9\uff0c\u6216\u4ece\u5f02\u6b65\u5206\u652f\u8d77\u70b9\u201c%s\u201d\u65e0\u6cd5\u5230\u8fbe\u6807\u8bb0\u7684\u5f02\u6b65\u5206\u652f\u7ec8\u70b9\u3002", "AsyncBeginPattern_1", "isc-iscb-platform-core", new Object[0]), asyncBeginNode);
            throw new IscBizException(message);
        }
        HashSet<NodeImpl> visitedPrior = new HashSet<NodeImpl>();
        this.findPrior(asyncEndNode, visitedPrior, asyncBeginNode);
        this.checkAsyncClosure(asyncBeginNode, visitedNext, asyncEndNode, visitedPrior);
        return asyncEndNode;
    }

    private void checkAsyncClosure(NodeImpl asyncBeginNode, Set<NodeImpl> visitedNext, NodeImpl asyncEndNode, Set<NodeImpl> visitedPrior) {
        visitedPrior.add(asyncBeginNode);
        visitedNext.add(asyncEndNode);
        if (!visitedPrior.equals(visitedNext)) {
            String message = String.format(ResManager.loadKDString("\u4ece\u5f02\u6b65\u5206\u652f\u8d77\u70b9\u201c%1$s\u201d\u5230\u7ec8\u70b9\u201c%2$s\u201d\u7684\u8def\u5f84\u4e0d\u662f\u5c01\u95ed\u7684\u3002", "AsyncBeginPattern_2", "isc-iscb-platform-core", new Object[0]), asyncBeginNode, asyncEndNode);
            throw new IscBizException(message);
        }
        Set<NodeImpl> visited = visitedNext;
        for (TransitionImpl t : asyncBeginNode.getInComing()) {
            NodeImpl from = t.getSource();
            if (!visited.contains(from)) continue;
            String message = String.format(ResManager.loadKDString("\u5f02\u6b65\u5206\u652f\u8282\u70b9\u201c%1$s\u201d\u4e0d\u5141\u8bb8\u8f6c\u79fb\u5230\u201c%2$s\u201d\u3002", "AsyncBeginPattern_3", "isc-iscb-platform-core", new Object[0]), from, asyncBeginNode);
            throw new IscBizException(message);
        }
        for (TransitionImpl t : asyncEndNode.getOutGoing()) {
            NodeImpl to = t.getTarget();
            if (!visited.contains(to)) continue;
            String message = String.format(ResManager.loadKDString("\u5f02\u6b65\u5206\u652f\u7ec8\u70b9\u201c%1$s\u201d\u4e0d\u5141\u8bb8\u8f6c\u79fb\u5230\u201c%2$s\u201d\u3002", "AsyncBeginPattern_4", "isc-iscb-platform-core", new Object[0]), asyncEndNode, to);
            throw new IscBizException(message);
        }
    }

    private NodeImpl findPrior(NodeImpl node, Set<NodeImpl> visited, NodeImpl asyncBeginNode) {
        if (!visited.add(node)) {
            return asyncBeginNode;
        }
        if (node.getPattern("ASYNC_BEGIN") != null) {
            if (asyncBeginNode == null || asyncBeginNode == node) {
                return node;
            }
            String message = String.format(ResManager.loadKDString("\u627e\u5230\u591a\u4e2a\u5f02\u6b65\u5206\u652f\u5f00\u59cb\u8282\u70b9\u201c%1$s\u201d\u4e0e\u201c%2$s\u201d\u3002", "AsyncBeginPattern_5", "isc-iscb-platform-core", new Object[0]), asyncBeginNode, node);
            throw new IscBizException(message);
        }
        for (TransitionImpl t : node.getInComing()) {
            node = t.getSource();
            asyncBeginNode = this.findPrior(node, visited, asyncBeginNode);
        }
        return asyncBeginNode;
    }

    private NodeImpl findEnd(NodeImpl node, Set<NodeImpl> visited, NodeImpl asyncEndNode) {
        if (!visited.add(node)) {
            return asyncEndNode;
        }
        if (node.getPattern("ASYNC_END") != null) {
            if (asyncEndNode == null || asyncEndNode == node) {
                return node;
            }
            String message = String.format(ResManager.loadKDString("\u627e\u5230\u591a\u4e2a\u5f02\u6b65\u5206\u652f\u7ed3\u675f\u8282\u70b9\u201c%1$s\u201d\u4e0e\u201c%2$s\u201d\u3002", "AsyncBeginPattern_6", "isc-iscb-platform-core", new Object[0]), asyncEndNode, node);
            throw new IscBizException(message);
        }
        for (TransitionImpl t : node.getOutGoing()) {
            node = t.getTarget();
            asyncEndNode = this.findEnd(node, visited, asyncEndNode);
        }
        return asyncEndNode;
    }
}

