/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.flow.core.i.pattern;

import java.util.ArrayList;
import java.util.List;
import kd.ai.gai.flow.except.IscBizException;
import kd.ai.gai.flow.flow.core.Transition;
import kd.ai.gai.flow.flow.core.i.c.common.TerminateSibling;
import kd.ai.gai.flow.flow.core.i.model.NodeImpl;
import kd.ai.gai.flow.flow.core.i.model.Pattern;
import kd.ai.gai.flow.flow.core.i.model.TransitionImpl;

public class ExitExclusive
extends Pattern {
    public static final Pattern PATTERN = new ExitExclusive();

    private ExitExclusive() {
        super(500, "EXIT_EXCLUSIVE", "EXIT_EXCLUSIVE");
    }

    @Override
    public void apply(NodeImpl node) {
        ArrayList<NodeImpl> exits = new ArrayList<NodeImpl>();
        for (TransitionImpl tran : node.getOutGoing()) {
            if (tran.getType() != Transition.Type.NORMAL) continue;
            exits.add(tran.getTarget());
        }
        for (NodeImpl current : exits) {
            List<NodeImpl> leafNodes = this.findLeafNodes(current);
            TerminateSibling cmd1 = this.seekCommand(current, leafNodes, 8000001);
            TerminateSibling cmd2 = this.seekCommand(current, leafNodes, 15000001);
            for (NodeImpl other : exits) {
                cmd1.addExclusiveNode(other.getId());
                cmd2.addExclusiveNode(other.getId());
            }
        }
    }

    private List<NodeImpl> findLeafNodes(NodeImpl node) {
        ArrayList<NodeImpl> children = new ArrayList<NodeImpl>();
        this.findLeafNodes(node, children);
        return children;
    }

    private void findLeafNodes(NodeImpl node, List<NodeImpl> children) {
        if (node.getChildrenCount() == 0) {
            children.add(node);
        } else {
            for (NodeImpl child : node.getChildren()) {
                this.findLeafNodes(child, children);
            }
        }
    }

    private TerminateSibling seekCommand(NodeImpl current, List<NodeImpl> leafNodes, int label) {
        TerminateSibling cmd = new TerminateSibling(current, label);
        for (NodeImpl node : leafNodes) {
            int index = node.seekCommand(label);
            if (index < 0 || node.getCommand(index).getLabel() != label) {
                node.insert(cmd);
                continue;
            }
            throw new IscBizException("TODO - Support more nodes.");
        }
        return cmd;
    }
}

