/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.flow.core.i.pattern;

import kd.ai.gai.flow.except.IscBizException;
import kd.ai.gai.flow.flow.core.i.c.common.Pause;
import kd.ai.gai.flow.flow.core.i.c.composite.CallSubFlow;
import kd.ai.gai.flow.flow.core.i.c.composite.WaitingForChildren;
import kd.ai.gai.flow.flow.core.i.model.NodeImpl;
import kd.ai.gai.flow.flow.core.i.model.Output;
import kd.ai.gai.flow.flow.core.i.model.Pattern;
import kd.ai.gai.flow.flow.core.i.model.VariableImpl;
import kd.ai.gai.flow.flow.core.plugin.SubFlowLoader;

public class SubFlow
extends Pattern {
    private SubFlowLoader loader;
    private String[] params;
    private String[] returns;

    public SubFlow(SubFlowLoader loader, String[] params, String[] returns) {
        super(500, "BIZ", "BIZ");
        this.loader = loader;
        this.params = (String[])params.clone();
        this.returns = (String[])returns.clone();
    }

    @Override
    public void apply(NodeImpl node) {
        if (node.isComposite()) {
            throw new IscBizException("Node '" + node + "' has children!");
        }
        VariableImpl[] paramVars = this.retrieveParamVars(node);
        VariableImpl[] returnVars = this.retrieveReturnVars(node);
        node.setOutput(new Output(returnVars));
        this.insertCommands(node, paramVars, returnVars);
        node.setSubFlowLoader(this.loader);
    }

    private void insertCommands(NodeImpl node, VariableImpl[] paramVars, VariableImpl[] returnVars) {
        CallSubFlow call = new CallSubFlow(this.loader, paramVars, returnVars);
        node.insert(call);
        node.insert(Pause.CMD_AFTER_APP_STARTED);
        node.insert(WaitingForChildren.CMD_AFTER_STARTED);
        node.setComposite();
    }

    private VariableImpl[] retrieveReturnVars(NodeImpl node) {
        VariableImpl[] returnVars = new VariableImpl[this.returns.length];
        for (int i = 0; i < this.returns.length; ++i) {
            returnVars[i] = node.retrieveVariable(this.returns[i]);
        }
        return returnVars;
    }

    private VariableImpl[] retrieveParamVars(NodeImpl node) {
        VariableImpl[] paramVars = new VariableImpl[this.params.length];
        for (int i = 0; i < this.params.length; ++i) {
            paramVars[i] = node.retrieveVariable(this.params[i]);
        }
        return paramVars;
    }
}

