/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.flow.core.i.profile;

import kd.ai.gai.flow.flow.core.Execution;
import kd.ai.gai.flow.flow.core.FlowRuntime;
import kd.ai.gai.flow.flow.core.FlowTrace;
import kd.ai.gai.flow.flow.core.ProfileLogger;
import kd.ai.gai.flow.flow.core.i.c.Command;

public final class Performance
implements FlowTrace {
    private Command current;
    private long startTime;
    private long beginTime;
    private FlowRuntime runtime;

    public Performance(FlowRuntime runtime) {
        this.runtime = runtime;
        this.beginTime = System.nanoTime();
        ProfileLogger.REF.get().logBegin(runtime);
    }

    @Override
    public FlowTrace clone() {
        return new Performance(this.runtime);
    }

    @Override
    public void begin(Execution e) {
        this.current = e.current();
        this.startTime = System.nanoTime();
    }

    @Override
    public boolean end(Execution e, boolean success) {
        long endTime = System.nanoTime();
        long elapsed = Math.max(0L, endTime - this.startTime);
        String message = e + ": \t" + this.current + ", " + elapsed / 1000L + "us.";
        ProfileLogger.REF.get().logExecute(e, message, success);
        return false;
    }

    @Override
    public void endFlow() {
        long now = System.nanoTime();
        String message = "total: " + (now - this.beginTime) / 1000L + " us.";
        ProfileLogger.REF.get().logEnd(this.runtime, message);
    }
}

