/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.flow.core.i.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.dataentity.resource.ResManager;
import kd.ai.gai.flow.except.IscBizException;
import kd.ai.gai.flow.flow.core.Execution;
import kd.ai.gai.flow.flow.core.Variable;
import kd.ai.gai.flow.flow.core.i.c.Command;
import kd.ai.gai.flow.flow.core.i.c.common.Pause;
import kd.ai.gai.flow.flow.core.i.model.AbstractExecutable;
import kd.ai.gai.flow.flow.core.i.model.AbstractVariableScope;
import kd.ai.gai.flow.flow.core.i.model.FlowImpl;
import kd.ai.gai.flow.flow.core.i.model.NodeImpl;
import kd.ai.gai.flow.flow.core.i.model.VariableImpl;
import kd.ai.gai.flow.flow.core.i.runtime.DataAreaImpl;
import kd.ai.gai.flow.flow.core.i.runtime.PropertyContainerImpl;
import kd.ai.gai.flow.flow.core.i.runtime.RuntimeImpl;
import kd.ai.gai.flow.flow.core.plugin.SubFlowLoader;
import kd.ai.gai.flow.flow.core.plugin.Synchronizer;

public final class ExecutionImpl
extends PropertyContainerImpl
implements Execution {
    private static final String RECOVERY = "recovery";
    private AbstractExecutable define;
    private DataAreaImpl mem;
    private String id;
    private ExecutionImpl parent;
    private ArrayList<ExecutionImpl> children;
    private int ip = 0;
    private int recovery = -1;
    private String priorId;
    private String priorNodeId;
    private String transitId;
    private boolean executing = false;

    private ExecutionImpl() {
    }

    static ExecutionImpl fromJson(HashMap<String, FlowImpl> flows, Map<String, Object> e, RuntimeImpl runtime, DataAreaImpl mem) {
        AbstractExecutable define = ExecutionImpl.checkDef(e, mem);
        ExecutionImpl exe = new ExecutionImpl();
        exe.define = define;
        exe.mem = mem;
        exe.id = (String)e.get("id");
        ExecutionImpl.restoreParent(e, runtime, exe);
        ExecutionImpl.restoreInstruction(e, exe);
        ExecutionImpl.restoreRecovery(e, exe);
        ExecutionImpl.restorePriorId(e, exe);
        ExecutionImpl.restoreEntryTransition(e, exe);
        runtime.register(exe);
        ExecutionImpl.retrieveSubFlow(flows, define, exe);
        exe.restoreProperties(e);
        return exe;
    }

    private static void restoreRecovery(Map<String, Object> e, ExecutionImpl exe) {
        int recovery = Integer.parseInt((String)e.get(RECOVERY));
        exe.recovery = recovery < 40000 ? recovery : exe.getDefine().seekCommand(recovery);
    }

    private static void restoreInstruction(Map<String, Object> e, ExecutionImpl exe) {
        int label = Integer.parseInt((String)e.get("ip"));
        exe.seek(label);
        int ip = exe.current().getLabel();
        if (ip != label) {
            String msg = "Command (" + label + ") doesn't match (" + exe.current() + "," + ip + ")";
            throw new IscBizException(msg);
        }
    }

    private static void retrieveSubFlow(HashMap<String, FlowImpl> flows, AbstractVariableScope scope, ExecutionImpl e) {
        NodeImpl node;
        SubFlowLoader loader;
        if (scope instanceof NodeImpl && (loader = (node = (NodeImpl)scope).getSubFlowLoader()) != null) {
            FlowImpl subflow = (FlowImpl)loader.getFlow(e);
            flows.put(subflow.getId(), subflow);
        }
    }

    private static void restoreParent(Map<String, Object> e, RuntimeImpl runtime, ExecutionImpl exe) {
        String parent = (String)e.get("parent");
        if (parent.length() > 0) {
            exe.parent = runtime.getExecution(parent);
            if (exe.parent == null) {
                throw new IscBizException("Parent execution (" + parent + ") not found!");
            }
            exe.parent.addChildren(exe);
        }
    }

    private static void restoreEntryTransition(Map<String, Object> e, ExecutionImpl exe) {
        exe.transitId = (String)e.get("entryTransition");
    }

    private static void restorePriorId(Map<String, Object> e, ExecutionImpl exe) {
        exe.priorId = (String)e.get("priorId");
        exe.priorNodeId = (String)e.get("priorNodeId");
    }

    private static AbstractExecutable checkDef(Map<String, Object> e, DataAreaImpl mem) {
        String defId;
        FlowImpl flow = mem.getFlow();
        AbstractExecutable scope = flow.getExecutable(defId = (String)e.get("def"));
        if (scope == null) {
            throw new IscBizException("Flow element (" + defId + ") not found!");
        }
        return scope;
    }

    void toJson(HashMap<String, Object> e) {
        e.put("id", this.id);
        e.put("def", this.define.getId());
        int label = this.executing ? this.next().getLabel() : this.current().getLabel();
        e.put("ip", String.valueOf(label));
        String parentId = this.parent == null ? "" : this.parent.getId();
        e.put("parent", parentId);
        this.saveRecovery(e);
        this.savePriorId(e);
        this.saveEntryTransition(e);
        this.saveProperties(e);
    }

    private void saveRecovery(HashMap<String, Object> e) {
        if (this.recovery < 0) {
            e.put(RECOVERY, String.valueOf(this.recovery));
        } else {
            int label = this.getDefine().getCommand(this.recovery).getLabel();
            e.put(RECOVERY, String.valueOf(label));
        }
    }

    private void saveEntryTransition(HashMap<String, Object> e) {
        if (this.transitId != null) {
            e.put("entryTransition", this.transitId);
        }
    }

    private void savePriorId(HashMap<String, Object> e) {
        if (this.priorId != null) {
            e.put("priorId", this.priorId);
        }
        if (this.priorNodeId != null) {
            e.put("priorNodeId", this.priorNodeId);
        }
    }

    public ExecutionImpl(ExecutionImpl parent, AbstractExecutable define, DataAreaImpl mem) {
        if (define.getFlow() != mem.getFlow()) {
            throw new IscBizException("Flow definitions dismatched!");
        }
        RuntimeImpl runtime = mem.getRuntime();
        this.setDefine(define, runtime);
        this.setMemory(mem);
        this.setParent(parent);
        runtime.register(this);
    }

    public void setPrior(String priorId, String priorNodeId, String transitionId) {
        this.priorId = priorId;
        this.transitId = transitionId;
        this.priorNodeId = priorNodeId;
    }

    @Override
    public String getPriorNodeId() {
        return this.priorNodeId;
    }

    private void setDefine(AbstractExecutable scope, RuntimeImpl runtime) {
        this.define = scope;
        int count = runtime.nextId();
        this.id = this.generateId(scope, runtime, count);
    }

    private String generateId(AbstractExecutable scope, RuntimeImpl runtime, int count) {
        String id = null;
        Synchronizer sync = scope.getSynchronizer();
        if (sync != null) {
            id = sync.newId(scope, runtime);
        }
        if (id == null) {
            id = String.valueOf(count);
        }
        return id;
    }

    private void setMemory(DataAreaImpl mem) {
        this.mem = mem;
        mem.add(this);
    }

    private void setParent(ExecutionImpl parent) {
        this.parent = parent;
        if (parent != null) {
            parent.addChildren(this);
        }
    }

    private void addChildren(ExecutionImpl child) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(child);
    }

    public void end() {
        this.mem.remove(this);
        RuntimeImpl runtime = this.mem.getRuntime();
        runtime.unregister(this);
        ArrayList<ExecutionImpl> list = this.parent.children;
        list.remove(this);
        if (list.size() == 0) {
            runtime.push(this.parent);
        }
        this.ip = -1;
    }

    @Override
    public String getTransitionId() {
        return this.transitId;
    }

    @Override
    public String getPriorId() {
        return this.priorId;
    }

    @Override
    public int getIp() {
        return this.ip;
    }

    @Override
    public boolean isClosed() {
        if (this.ip < 0) {
            return true;
        }
        if (this.recovery < 0) {
            return this.ip >= 19000000;
        }
        return this.recovery >= 19000000;
    }

    public void seek(int label) {
        int address = this.getDefine().seekCommand(label);
        if (address < 0) {
            throw new IscBizException("Can't find command " + label + " in from " + this.define + "!");
        }
        this.ip = address;
    }

    public void dispose() {
        if (this.parent != null) {
            this.parent.children.remove(this);
        }
        this.getRuntime().unregister(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public AbstractExecutable getDefine() {
        return this.define;
    }

    @Override
    public RuntimeImpl getRuntime() {
        return this.mem.getRuntime();
    }

    @Override
    public ExecutionImpl getParent() {
        return this.parent;
    }

    public List<ExecutionImpl> getChildren() {
        if (this.children == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.children);
    }

    public int getChildrenCount() {
        return this.children == null ? 0 : this.children.size();
    }

    @Override
    public Object get(String var) {
        VariableImpl v = this.define.findVariable(var);
        if (v != null) {
            return this.mem.getAt(v);
        }
        if ("#EXECUTION".equals(var)) {
            return this.getId();
        }
        if ("#DEFINE".equals(var)) {
            return this.getDefine();
        }
        if ("#RUNTIME".equals(var)) {
            return this.getRuntime();
        }
        if ("$error".equals(var)) {
            return this.getRuntime().getError();
        }
        return this.getProperty(var);
    }

    @Override
    public boolean contains(String var) {
        VariableImpl v = this.define.findVariable(var);
        if (v != null) {
            return true;
        }
        if ("#EXECUTION".equals(var)) {
            return true;
        }
        if ("#DEFINE".equals(var)) {
            return true;
        }
        if ("#RUNTIME".equals(var)) {
            return true;
        }
        if ("$error".equals(var)) {
            return true;
        }
        return this.hasProperty(var);
    }

    @Override
    public Variable find(String name) {
        return this.define.findVariable(name);
    }

    @Override
    public Object get(Variable address) {
        return this.mem.getAt((VariableImpl)address);
    }

    @Override
    public boolean set(String var, Object value) {
        VariableImpl v = this.define.findVariable(var);
        if (v == null) {
            return false;
        }
        this.mem.setAt(v, value);
        return true;
    }

    @Override
    public void set(Variable address, Object value) {
        this.mem.setAt((VariableImpl)address, value);
    }

    @Override
    public DataAreaImpl getMemory() {
        return this.mem;
    }

    public String toString() {
        return this.getDefine().toString() + "(" + this.id + ")@" + this.mem.getId();
    }

    public void bizFailed() {
        this.saveRecovery();
        this.seek(26000000);
        this.getRuntime().pushAtFirst(this);
    }

    @Override
    public void appFailed(Throwable cause) {
        if (!this.isBeforePartiallyCompleted()) {
            throw new UnsupportedOperationException(String.format(ResManager.loadKDString("\u5f53\u524d\u6307\u4ee4\u201c%s\u201d\u4e0d\u652f\u6301\u3002", "ExecutionImpl_12", "isc-iscb-util", new Object[0]), this.ip));
        }
        this.setTransientProperty("EXTERNAL_ERROR", cause);
        this.seek(5000000);
        this.bizFailed();
    }

    @Override
    public void restoreAppError() {
        Throwable cause = (Throwable)this.getTransientProperty("EXTERNAL_ERROR");
        if (cause != null) {
            this.setTransientProperty("EXTERNAL_ERROR", null);
            this.getRuntime().pushError(cause);
        }
    }

    @Override
    public void suspend() {
        if (!this.isInterrupted()) {
            this.saveRecovery();
            this.seek(27000002);
            this.getRuntime().pushAtFirst(this);
        }
    }

    public void leapOver() {
        this.seek(34000000);
        RuntimeImpl runtime = this.getRuntime();
        runtime.pushAtFirst(this);
    }

    @Override
    public void terminate() {
        ExecutionImpl.terminationCheck(this);
        this.seek(34000001);
        RuntimeImpl runtime = this.getRuntime();
        runtime.pushAtFirst(this);
    }

    private static void terminationCheck(ExecutionImpl e) {
        ExecutionImpl.innerTerminationCheck(e);
        for (ExecutionImpl c : e.getChildren()) {
            ExecutionImpl.terminationCheck(c);
        }
    }

    private static void innerTerminationCheck(ExecutionImpl e) {
        AbstractExecutable def = e.getDefine();
        if (def instanceof NodeImpl && ((NodeImpl)def).isCompensation()) {
            throw new UnsupportedOperationException(String.format(ResManager.loadKDString("\u201c%s\u201d\u662f\u8865\u507f\u8282\u70b9\uff0c\u4e0d\u5141\u8bb8\u4e2d\u6b62\u3002", "ExecutionImpl_13", "isc-iscb-util", new Object[0]), def.getTitle()));
        }
    }

    private void saveRecovery() {
        if (this.recovery < 0) {
            this.recovery = this.ip;
        }
    }

    public void restorRecovery() {
        this.ip = this.popRecovery();
        this.getRuntime().pushAtFirst(this);
    }

    public boolean signal() {
        if (this.ip >= 0 && this.recovery < 0 && this.current() instanceof Pause) {
            ++this.ip;
            this.getRuntime().pushAtFirst(this);
            return true;
        }
        return false;
    }

    @Override
    public boolean isBeforePartiallyCompleted() {
        return this.current().getLabel() <= 7000000;
    }

    @Override
    public boolean isStarted() {
        Command i = this.getBizCommand();
        return i.getLabel() > 2000000;
    }

    private Command getBizCommand() {
        Command i = this.recovery < 0 ? this.current() : this.define.getCommand(this.recovery);
        return i;
    }

    public boolean isAppComplete() {
        Command i = this.getBizCommand();
        return i.getLabel() >= 19000000;
    }

    @Override
    public boolean isAppStarted() {
        Command i = this.getBizCommand();
        return i.getLabel() > 5000000;
    }

    @Override
    public void resume() {
        if (this.isInterrupted() && this.current() instanceof Pause) {
            ++this.ip;
            this.getRuntime().push(this);
        }
    }

    @Override
    public boolean isInterrupted() {
        return this.recovery >= 0;
    }

    @Override
    public boolean isHalted() {
        return this.current() instanceof Pause;
    }

    @Override
    public void reset(String var) {
        VariableImpl v = this.getDefine().retrieveVariable(var);
        this.mem.reset(v);
    }

    @Override
    public void clear(String var) {
        VariableImpl v = this.getDefine().retrieveVariable(var);
        this.mem.clear(v);
    }

    @Override
    public void clear(Variable address) {
        this.mem.clear((VariableImpl)address);
    }

    @Override
    public void reset(Variable address) {
        this.mem.reset((VariableImpl)address);
    }

    public void clearRecovery() {
        this.checkRecovery();
        this.recovery = -1;
    }

    private void checkRecovery() {
        if (this.recovery < 0) {
            throw new IscBizException("Recovery point doesn't exist in '" + this + "'.");
        }
    }

    public int popRecovery() {
        this.checkRecovery();
        int ip = this.recovery;
        this.recovery = -1;
        return ip;
    }

    @Override
    public Command current() {
        return this.define.getCommand(this.ip);
    }

    public Command next() {
        return this.define.getCommand(this.ip + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean execute() {
        int ip = this.ip;
        Command i = this.define.getCommand(ip);
        this.executing = true;
        try {
            int next = i.invoke(this);
            boolean bl = this.postHandle(ip, next);
            return bl;
        }
        finally {
            this.executing = false;
        }
    }

    private boolean postHandle(int ip, int next) {
        if (ip != this.ip) {
            return false;
        }
        switch (next) {
            case 1: {
                ++this.ip;
                return true;
            }
            case 0: {
                return false;
            }
        }
        this.seek(next);
        return true;
    }

    @Override
    public void ignoreBiz() {
        if (this.isAppStarted()) {
            throw new IscBizException(String.format(ResManager.loadKDString("'%s' \u7684\u4e1a\u52a1\u5df2\u7ecf\u6267\u884c\uff0c\u4e0d\u80fd\u5ffd\u7565\u3002", "ExecutionImpl_14", "isc-iscb-util", new Object[0]), this));
        }
        this.recovery = -1;
        this.seek(15000000);
        this.getRuntime().pushAtFirst(this);
    }

    @Override
    public void completeBiz() {
        if (this.isAppStarted()) {
            throw new IscBizException(String.format(ResManager.loadKDString("'%s' \u7684\u4e1a\u52a1\u5df2\u7ecf\u6267\u884c\uff0c\u4e0d\u80fd\u518d\u6b21\u8bbe\u7f6e\u4e1a\u52a1\u4e3a\u5df2\u5b8c\u6210\u3002", "ExecutionImpl_15", "isc-iscb-util", new Object[0]), this));
        }
        this.recovery = -1;
        this.seek(5000001);
        this.getRuntime().pushAtFirst(this);
    }

    @Override
    public void stop() {
        if (this.isAppComplete()) {
            throw new IscBizException(String.format(ResManager.loadKDString("'%s' \u7684\u4e1a\u52a1\u5df2\u7ecf\u5b8c\u6210\uff0c\u4e0d\u80fd\u505c\u6b62\u5f53\u524d\u8282\u70b9\u7684\u6267\u884c\u3002", "ExecutionImpl_16", "isc-iscb-util", new Object[0]), this));
        }
        this.forceStop();
    }

    public void forceStop() {
        this.recovery = -1;
        this.seek(21000000);
        this.getRuntime().pushAtFirst(this);
    }
}

