/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.flow.trace;

import java.util.LinkedHashMap;
import java.util.Map;
import kd.ai.gai.flow.debugger.DebugCoordinator;
import kd.ai.gai.flow.debugger.DebuggableResource;
import kd.ai.gai.flow.debugger.DebuggableRuntime;
import kd.ai.gai.flow.flow.core.Execution;
import kd.ai.gai.flow.flow.core.FlowTrace;
import kd.ai.gai.flow.flow.core.i.model.AbstractVariableScope;
import kd.ai.gai.flow.flow.core.i.model.VariableImpl;
import kd.ai.gai.flow.flow.trace.FlowDebuggerResource;
import kd.ai.gai.flow.script.context.Context;
import kd.ai.gai.flow.script.encoding.Hash;

public class FlowDebuggerTrace
implements FlowTrace {
    private FlowDebuggerResource res;

    public FlowDebuggerTrace(FlowDebuggerResource res) {
        this.res = res;
    }

    @Override
    public FlowTrace clone() {
        return new FlowDebuggerTrace(this.res);
    }

    @Override
    public void begin(Execution e) {
        DebugCoordinator c = DebugCoordinator.REF.get();
        if (!c.isDebuggerEnabled()) {
            return;
        }
        if (!this.res.hasBreakpoint(e)) {
            return;
        }
        DebuggableRuntime runtime = this.newDebuggableRuntime(e);
        c.handleBreakpoint(runtime, this.res.getLine(e), this.res.collectBreakpoints());
    }

    private DebuggableRuntime newDebuggableRuntime(final Execution e) {
        return new DebuggableRuntime(){
            private String id;
            {
                this.id = Hash.md5(e.getRuntime().getId() + "@" + Thread.currentThread());
            }

            @Override
            public String getId() {
                return this.id;
            }

            @Override
            public DebuggableResource getResource() {
                return FlowDebuggerTrace.this.res;
            }

            @Override
            public Context getContext() {
                return new Context(){

                    @Override
                    public Object get(String property) {
                        if ("#vars".equals(property)) {
                            return this.getVariables(e);
                        }
                        Object value = e.getRuntime().getTransientProperty(property);
                        if (value != null) {
                            return value;
                        }
                        return e.get(property);
                    }

                    private Object getVariables(Execution e) {
                        AbstractVariableScope scope = (AbstractVariableScope)e.getDefine();
                        Map<String, VariableImpl> availableVariables = scope.getAvailableVariables();
                        LinkedHashMap<String, String> vars = new LinkedHashMap<String, String>(availableVariables.size());
                        for (Map.Entry<String, VariableImpl> i : availableVariables.entrySet()) {
                            vars.put(i.getKey(), i.getValue().getTitle());
                        }
                        return vars;
                    }

                    @Override
                    public boolean set(String property, Object value) {
                        return false;
                    }

                    @Override
                    public boolean contains(String property) {
                        return false;
                    }
                };
            }
        };
    }

    @Override
    public boolean end(Execution e, boolean success) {
        return false;
    }

    @Override
    public void endFlow() {
    }
}

