/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.flow.trace;

import java.util.ArrayList;
import java.util.List;
import kd.ai.gai.flow.flow.core.Flow;
import kd.ai.gai.flow.flow.core.i.adapter.Ready;
import kd.ai.gai.flow.flow.core.i.c.Command;
import kd.ai.gai.flow.flow.core.i.c.DebuggerBreakpoint;
import kd.ai.gai.flow.flow.core.i.c.composite.CallSubFlow;
import kd.ai.gai.flow.flow.core.i.model.NodeImpl;
import kd.ai.gai.flow.flow.trace.Line;

public class NodeLineCollector {
    public static List<Line> collectLines(Flow flow) {
        ArrayList<Line> lines = new ArrayList<Line>();
        NodeLineCollector.collectLines((NodeImpl)flow.getRoot(), 0, lines);
        return lines;
    }

    private static void collectLines(NodeImpl node, int tab, List<Line> lines) {
        if (node.getParent() == null) {
            lines.add(new Line(node.getFlow().getTitle() + " {", node, 0, tab));
            NodeLineCollector.collectChildrenLines(node, tab + 1, lines);
            lines.add(new Line("}", tab));
        } else {
            NodeLineCollector.collectCommandLines(node, tab, lines);
            NodeLineCollector.collectSubFlowLines(node, tab + 1, lines);
            NodeLineCollector.collectChildrenLines(node, tab + 1, lines);
        }
    }

    private static void collectCommandLines(NodeImpl node, int tab, List<Line> lines) {
        Command cmd;
        int i;
        int j = node.getCommandCount();
        for (i = 0; i < j; ++i) {
            cmd = node.getCommand(i);
            if (!(cmd instanceof DebuggerBreakpoint)) continue;
            String text = node.getTitle() + "@" + node.getId() + ";";
            lines.add(new Line(text, node, i, tab));
            return;
        }
        j = node.getCommandCount();
        for (i = 0; i < j; ++i) {
            cmd = node.getCommand(i);
            if (!(cmd instanceof Ready)) continue;
            String text = node.getTitle() + "@" + node.getId() + ";";
            lines.add(new Line(text, node, i, tab));
            return;
        }
    }

    private static void collectChildrenLines(NodeImpl node, int tab, List<Line> lines) {
        for (String id : node.getGraph().wfsVisit()) {
            NodeImpl child = node.getFlow().getNode(id);
            NodeLineCollector.collectLines(child, tab, lines);
        }
    }

    private static void collectSubFlowLines(NodeImpl node, int tab, List<Line> lines) {
        int j = node.getCommandCount();
        for (int i = 0; i < j; ++i) {
            Flow flow;
            Command cmd = node.getCommand(i);
            if (!(cmd instanceof CallSubFlow) || (flow = ((CallSubFlow)cmd).getLoader().getFlow(null)) == null) continue;
            NodeLineCollector.collectLines((NodeImpl)flow.getRoot(), tab, lines);
        }
    }
}

