/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.format;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import kd.ai.gai.dataentity.resource.ResManager;
import kd.ai.gai.flow.err.CommonError;
import kd.ai.gai.flow.format.Else;
import kd.ai.gai.flow.format.Expr;
import kd.ai.gai.flow.format.ForEach;
import kd.ai.gai.flow.format.If;
import kd.ai.gai.flow.format.PlainText;
import kd.ai.gai.flow.format.Snippet;
import kd.ai.gai.flow.script.LifeScriptContext;
import kd.ai.gai.flow.script.accessor.TestedBeforeNameAccessor;
import kd.ai.gai.flow.script.context.ArrayContext;
import kd.ai.gai.flow.script.context.Context;
import kd.ai.gai.flow.script.core.Identifier;
import kd.ai.gai.flow.script.feature.tool.string.ToString;

public class Format
implements Serializable {
    public static final char LP = '{';
    public static final char RP = '}';
    public static final String PREFIX = "#{";
    public static final String SUFFIX = "}";
    public static final String FOR_EACH = "for-each:";
    public static final String RENAME = "->";
    public static final String IF = "if:";
    public static final String ELSE = "else:";
    private static final long serialVersionUID = -7273825499718211282L;
    private String _format;
    private List<Snippet> contents;
    private static final Identifier ACCESSOR = new TestedBeforeNameAccessor();

    private Format(String format, Map<String, Object> ctx) throws ScriptException {
        if (format == null) {
            format = "";
        }
        this._format = format;
        this.contents = new LinkedList<Snippet>();
        this.parseFormat(format, ctx);
        this.contents = Collections.unmodifiableList(this.contents);
    }

    public String getFormat() {
        return this._format;
    }

    private void parseFormat(String format, Map<String, Object> ctx) throws ScriptException {
        int i;
        int current = 0;
        while ((i = format.indexOf(PREFIX, current)) >= 0) {
            int j = this.findEndToken(format, i + PREFIX.length());
            if (j < 0) {
                throw new IllegalArgumentException(String.format(ResManager.loadKDString("\u62ec\u53f7\u4e0d\u5339\u914d\uff0c\u6a21\u677f\u662f\uff1a%s", "Format_1", "isc-iscb-util", new Object[0]), format));
            }
            this.addPlainText(format, current, i);
            this.addPropertyRef(format, i, j, ctx);
            current = j + SUFFIX.length();
        }
        this.addPlainText(format, current, format.length());
    }

    private int findEndToken(String format, int start) {
        int j = -1;
        int count = 0;
        char lp = '{';
        char rp = '}';
        while (start < format.length()) {
            char c = format.charAt(start);
            if (rp == c) {
                if (count == 0) {
                    j = start;
                    break;
                }
                --count;
            } else if (lp == c) {
                ++count;
            }
            ++start;
        }
        return j;
    }

    private void addPropertyRef(String format, int i, int j, Map<String, Object> ctx) throws ScriptException {
        int current = i + PREFIX.length();
        String name = format.substring(current, j);
        if (name.length() == 0) {
            this.contents.add(new PlainText("#{}"));
        } else if (name.startsWith(FOR_EACH)) {
            this.contents.add(new ForEach(name.substring(FOR_EACH.length()), ctx));
        } else if (name.startsWith(IF)) {
            this.contents.add(new If(name.substring(IF.length()), ctx));
        } else if (name.startsWith(ELSE)) {
            this.contents.add(new Else(name.substring(ELSE.length()), ctx));
        } else {
            this.contents.add(new Expr(name, ctx));
        }
    }

    private void addPlainText(String format, int current, int i) {
        if (i > current) {
            String text = format.substring(current, i);
            PlainText p = new PlainText(text);
            this.contents.add(p);
        }
    }

    public String translate(Context ctx) {
        return this.translate(new LifeScriptContext(ctx));
    }

    public String translate(Map<String, Object> ctx) {
        return this.translate(new LifeScriptContext(ctx));
    }

    public String translate(Object[] ctx) {
        return this.translate(new LifeScriptContext(new ArrayContext(ctx)));
    }

    public String translate(ScriptContext ctx) {
        Object v = this.translateValue(ctx);
        if (v == null) {
            return "";
        }
        return ToString.toString(v);
    }

    Object translateValue(ScriptContext ctx) {
        if (this.contents.size() == 1) {
            return this.contents.get(0).getFrom(ctx);
        }
        StringBuilder sb = new StringBuilder(this._format.length());
        for (Snippet p : this.contents) {
            Object value = p.getFrom(ctx);
            if (value == null) continue;
            String text = ToString.toString(value);
            sb.append(text);
        }
        return sb.toString();
    }

    public String toString() {
        return this._format;
    }

    public static Format parse(String format, Map<String, Object> sctx) {
        sctx.put(".", ACCESSOR);
        try {
            return new Format(format, sctx);
        }
        catch (ScriptException e) {
            throw CommonError.INVALID_MSG_TEMPLATE.wrap(e);
        }
    }
}

