/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.io;

public class Counter {
    private int total_count = 0;
    private int success_count = 0;
    private int failed_count = 0;
    private int ignored_count = 0;
    private long start_time = 0L;
    private long prepare_time = 0L;
    private long read_time = 0L;
    private long convert_time = 0L;
    private long loading_time = 0L;
    private long read_bytes = 0L;
    private long load_bytes = 0L;
    private int thread_count = 1;
    private int batch_size = 1;

    public synchronized void setStartTime(long start_time) {
        this.start_time = start_time;
    }

    public int getBatchSize() {
        return this.batch_size;
    }

    public void setBatchSize(int batch_size) {
        this.batch_size = batch_size;
    }

    public synchronized long getStartTime() {
        return this.start_time;
    }

    public synchronized long getPrepareTime() {
        return this.prepare_time;
    }

    public synchronized void incPrepareTime(long prepare_time) {
        this.prepare_time += prepare_time;
    }

    public synchronized long getReadTime() {
        return this.read_time;
    }

    public synchronized void incReadTime(long read_time) {
        this.read_time += read_time;
    }

    public synchronized long getConvertTime() {
        return this.convert_time;
    }

    public synchronized void incConvertTime(long convert_time) {
        this.convert_time += convert_time;
    }

    public synchronized long getLoadTime() {
        long load_time = this.loading_time;
        return load_time;
    }

    public synchronized void incLoadTime(long loading_time) {
        this.loading_time += loading_time;
    }

    public synchronized long getReadBytes() {
        return this.read_bytes;
    }

    public synchronized void incReadBytes(long read_bytes) {
        this.read_bytes += read_bytes;
    }

    public synchronized long getLoadBytes() {
        return this.load_bytes;
    }

    public synchronized void incLoadBytes(long load_bytes) {
        this.load_bytes += load_bytes;
    }

    public synchronized int getTotalCount() {
        return this.total_count;
    }

    public synchronized int getSuccessCount() {
        return this.success_count;
    }

    public synchronized int getFailedCount() {
        return this.failed_count;
    }

    public synchronized int getIgnoredCount() {
        return this.ignored_count;
    }

    public synchronized void incFailedCount(int batch) {
        this.failed_count += batch;
        this.adjustTotalCount();
    }

    public synchronized void incSuccessCount(int batch) {
        this.success_count += batch;
        this.adjustTotalCount();
    }

    public synchronized void incIgnoredCount(int batch) {
        this.ignored_count += batch;
        this.adjustTotalCount();
    }

    public synchronized void setTotalCount(int totalCount) {
        this.total_count = totalCount;
    }

    public synchronized void resetTotalCount() {
        int total;
        this.total_count = total = this.success_count + this.failed_count + this.ignored_count;
    }

    private void adjustTotalCount() {
        int total = this.success_count + this.failed_count + this.ignored_count;
        this.total_count = Math.max(this.total_count, total);
    }

    public synchronized void rollback() {
        this.success_count = 0;
        this.failed_count = 0;
        this.ignored_count = 0;
        this.prepare_time = 0L;
        this.read_time = 0L;
        this.convert_time = 0L;
        this.loading_time = 0L;
        this.read_bytes = 0L;
        this.load_bytes = 0L;
    }

    public synchronized void incThreadCount() {
        ++this.thread_count;
    }

    public synchronized void decThreadCount() {
        --this.thread_count;
    }

    public synchronized void resetThreadCount() {
        this.thread_count = 1;
    }

    public synchronized int getThreadCount() {
        return this.thread_count;
    }
}

