/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.io;

import kd.ai.gai.flow.io.ObjectReader;

public final class SynchronizedObjectReader<T>
implements ObjectReader<T> {
    private ObjectReader<T> reader;

    public SynchronizedObjectReader(ObjectReader<T> reader) {
        assert (reader != null);
        this.reader = reader;
    }

    @Override
    public synchronized int getTotalCount() {
        ObjectReader<T> reader = this.reader;
        if (reader != null) {
            return reader.getTotalCount();
        }
        return -1;
    }

    @Override
    public synchronized T read() {
        ObjectReader<T> reader = this.reader;
        if (reader != null) {
            return reader.read();
        }
        return null;
    }

    @Override
    public synchronized void close() {
        ObjectReader<T> reader = this.reader;
        if (reader != null) {
            reader.close();
            this.reader = null;
        }
    }
}

