/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.misc;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import kd.ai.gai.dataentity.resource.ResManager;
import kd.ai.gai.flow.dt.D;
import kd.ai.gai.flow.err.CommonError;
import kd.ai.gai.flow.misc.NetUtil;

public class FileUtil {
    public static String read(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return null;
        }
        try {
            return FileUtil.read(file);
        }
        catch (Exception e) {
            throw D.e(e);
        }
    }

    public static String read(File file) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            String string = FileUtil.read(in);
            return string;
        }
    }

    public static String read(InputStream in) {
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)new BufferedInputStream(in), D.UTF_8);
            StringBuilder sb = new StringBuilder();
            int c = reader.read();
            while (c >= 0) {
                sb.append((char)c);
                c = reader.read();
            }
            return sb.toString();
        }
        catch (IOException e) {
            throw CommonError.INPUT_READER_FAILURE.wrap(e);
        }
    }

    public static String load(String resource) throws IOException {
        InputStream is = FileUtil.class.getClassLoader().getResource(resource).openStream();
        return NetUtil.readText(is);
    }

    public static void checkFilePath(String filePath) {
        if (filePath.indexOf(37) >= 0) {
            throw new IllegalArgumentException(ResManager.loadKDString("\u6587\u4ef6\u8def\u5f84\u4e2d\u7981\u6b62\u5305\u542b%", "FileUtil_0", "isc-iscb-util", new Object[0]));
        }
        if (filePath.contains("/../") || filePath.contains("\\..\\")) {
            throw new IllegalArgumentException(ResManager.loadKDString("\u6587\u4ef6\u8def\u5f84\u4e2d\u7981\u6b62\u5305\u542b\u53cc\u5c0f\u6570\u70b9\u3002", "FileUtil_1", "isc-iscb-util", new Object[0]));
        }
    }
}

