/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.misc;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.ai.gai.flow.dt.D;
import kd.ai.gai.flow.misc.NetUtil;

public class HttpConnectionDecorator
implements NetUtil.ConnectionDecorator {
    private final Map<String, Object> cookies;
    private final Map<String, Object> header;
    private int responseCode;

    public HttpConnectionDecorator(Map<String, Object> cookies, Map<String, Object> header) {
        this.cookies = cookies;
        this.header = header;
    }

    public Map<String, Object> getCookies() {
        return this.cookies;
    }

    public Map<String, Object> getHeader() {
        return this.header;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    @Override
    public void beforeSubmit(HttpURLConnection http) {
        this.setCookie(http);
        this.setHttpHeader(http);
    }

    private void setHttpHeader(HttpURLConnection http) {
        if (this.header.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Object> entry : this.header.entrySet()) {
            http.setRequestProperty(entry.getKey(), D.s(entry.getValue()));
        }
    }

    private void setCookie(HttpURLConnection http) {
        if (this.cookies.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> e : this.cookies.entrySet()) {
            String name = e.getKey();
            String value = D.s(e.getValue());
            if (sb.length() > 0) {
                sb.append(';');
            }
            sb.append(name).append('=').append(value);
        }
        http.setRequestProperty("Cookie", sb.toString());
    }

    @Override
    public void afterSubmit(HttpURLConnection http) {
        this.setResponseCode(http);
        this.getCookies(http);
        this.getHeaders(http);
        HttpConnectionDecorator.removeEmptyKey(this.header);
        HttpConnectionDecorator.removeEmptyKey(this.cookies);
    }

    private void setResponseCode(HttpURLConnection http) {
        try {
            this.responseCode = http.getResponseCode();
        }
        catch (IOException e) {
            this.responseCode = 0;
        }
    }

    private void getHeaders(HttpURLConnection http) {
        Map<String, List<String>> headers = http.getHeaderFields();
        for (Map.Entry<String, List<String>> e : headers.entrySet()) {
            String key = e.getKey();
            if (key == null) {
                this.header.put("", e.getValue());
                continue;
            }
            this.header.put(key, e.getValue());
        }
        this.header.put("#RESPONSE_URL", D.s(http.getURL()));
    }

    private static void removeEmptyKey(Map<String, Object> map) {
        Iterator<Map.Entry<String, Object>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> e = it.next();
            if (e.getKey() != null) continue;
            it.remove();
        }
    }

    private void getCookies(HttpURLConnection http) {
        String key;
        int i = 1;
        while ((key = http.getHeaderFieldKey(i)) != null) {
            if ("Set-Cookie".equals(key)) {
                String value;
                String name;
                String s = http.getHeaderField(i);
                int j = s.indexOf(59);
                if (j > 0) {
                    s = s.substring(0, j);
                }
                if ((j = s.indexOf(61)) >= 0) {
                    name = s.substring(0, j);
                    value = s.substring(j + 1);
                } else {
                    value = s;
                    name = "";
                }
                this.cookies.put(name, value);
            }
            ++i;
        }
    }
}

