/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.misc;

import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import kd.ai.gai.flow.data.Counter;
import kd.ai.gai.flow.dt.D;

public class SimpleFC {
    private static ConcurrentHashMap<String, Item> tps_threshold = new ConcurrentHashMap();
    private static final Random rnd = new Random();

    public static void setMaxTPS(String ip, int port, int maxTPS) {
        if (maxTPS <= 0) {
            return;
        }
        SimpleFC.setMaxTPS(ip + ":" + port, maxTPS);
    }

    public static void setMaxTPS(long dbLink, int maxTPS) {
        if (maxTPS <= 0) {
            return;
        }
        SimpleFC.setMaxTPS(String.valueOf(dbLink), maxTPS);
    }

    public static void setMaxTpsByKey(String key, int maxTPS) {
        if (maxTPS <= 0) {
            return;
        }
        SimpleFC.setMaxTPS(key, maxTPS);
    }

    public static void visit(long dbLink) {
        String key = String.valueOf(dbLink);
        SimpleFC.innerVisit(key);
    }

    public static void visitByKey(String key) {
        SimpleFC.innerVisit(key);
    }

    private static void setMaxTPS(String key, int maxTPS) {
        Item i = tps_threshold.get(key);
        if (i == null || maxTPS < i.maxTPS) {
            tps_threshold.put(key, new Item(maxTPS));
        }
    }

    public static String visit(String url) {
        String key = SimpleFC.getHost(url);
        return SimpleFC.innerVisit(key);
    }

    public static void visit(String ip, int port) {
        String key = ip + ":" + port;
        SimpleFC.innerVisit(key);
    }

    private static String innerVisit(String key) {
        Item i = tps_threshold.get(key);
        if (i != null) {
            SimpleFC.doFC(key, i);
        }
        return key;
    }

    private static void doFC(String key, Item i) {
        Counter counter = i.counter;
        while (counter.get() >= i.threshold) {
            int millis = 5 + rnd.nextInt(30);
            D.sleep(millis);
        }
        counter.inc(1);
    }

    private static String getHost(String url) {
        int start = url.indexOf("://") + "://".length();
        if (start < "://".length()) {
            return url;
        }
        int end = url.indexOf(47, start);
        if (end < 0) {
            return url.substring(start);
        }
        return url.substring(start, end);
    }

    public static void clear() {
        tps_threshold.clear();
    }

    private static class Item {
        private int threshold;
        private Counter counter;
        private int maxTPS;

        Item(int maxTPS) {
            int interval = 5;
            int millis = 200 / Math.max(1, (int)(Math.log(maxTPS) * 2.0));
            this.counter = new Counter(millis, 5);
            this.maxTPS = maxTPS;
            int timeunit = millis * 5;
            this.threshold = Math.max(1, (int)Math.round((double)(maxTPS * timeunit) / 1000.0));
        }
    }
}

