/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.misc;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Array;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.flow.data.LocalCache;
import kd.ai.gai.flow.dt.D;
import kd.ai.gai.flow.err.CommonError;
import kd.ai.gai.flow.misc.NetUtil;
import kd.ai.gai.flow.script.misc.Xml;
import kd.ai.gai.flow.script.misc.log.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class WebServiceStub {
    private static final String SOAP_ACTION = "SOAPAction";
    private Logger log;
    private String url;
    private String charset;
    private String m_domain;
    private boolean isAsmx;
    private static final LocalCache<String, String> cache = new LocalCache(2048);

    public WebServiceStub(String url, String charset) {
        this(url, charset, Logger.NONE);
    }

    public WebServiceStub(String url, String charset, Logger log) {
        this.isAsmx = url.endsWith(".asmx");
        this.url = url;
        this.log = log;
        this.charset = charset;
        this.m_domain = WebServiceStub.getDomain(url);
    }

    private static String getDomain(String url) {
        String domain = cache.get(url);
        if (domain == null) {
            domain = WebServiceStub.loadDomain(url);
            cache.put(url, domain);
        }
        return domain;
    }

    private static String loadDomain(String url) {
        try {
            String xml = NetUtil.httpRead(url + "?WSDL", "UTF-8");
            Document doc = Xml.parse(xml);
            Element root = doc.getDocumentElement();
            return root.getAttribute("targetNamespace");
        }
        catch (Exception e) {
            throw CommonError.WSDL_ERROR.create(e, url, e.getMessage());
        }
    }

    public Object invoke(String method, Map<String, Object> params) {
        return this.invoke(method, params, NetUtil.ConnectionDecorator.NONE);
    }

    public Object invoke(String method, Map<String, Object> params, NetUtil.ConnectionDecorator decorator) {
        String data = this.generateSoapMessage(method, params);
        this.log.info(data);
        try {
            HttpURLConnection http = this.send(method, data, decorator);
            return this.handleResponse(http);
        }
        catch (IOException e) {
            throw CommonError.WEB_SERVICE_ERROR.wrap(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object handleResponse(HttpURLConnection http) throws IOException {
        int code = http.getResponseCode();
        switch (code) {
            case 200: {
                try (InputStream in = http.getInputStream();){
                    Object object = this.parseResponse(this.readResponse(in));
                    return object;
                }
            }
        }
        return this.parseError(http, code);
    }

    private Object parseError(HttpURLConnection http, int code) throws IOException {
        try (InputStream err = http.getErrorStream();){
            String xml = this.readResponse(err);
            Object result = this.parseResponse(xml);
            if (result instanceof Map) {
                Map map = (Map)result;
                map.put("$failed", Boolean.TRUE);
                map.put("$responseCode", code);
                map.put("$responseMessage", http.getResponseMessage());
                Map map2 = map;
                return map2;
            }
            throw new IOException(xml);
        }
    }

    private Object parseResponse(String xml) {
        this.log.info(xml);
        Document doc = Xml.parse(xml);
        Element node = doc.getDocumentElement();
        return WebServiceStub.wrap(node.getChildNodes());
    }

    public static Object wrap(NodeList children) {
        switch (children.getLength()) {
            case 0: {
                return null;
            }
            case 1: {
                Node e = children.item(0);
                if (e instanceof Text) {
                    return e.getTextContent();
                }
                return WebServiceStub.wrapList(children);
            }
        }
        return WebServiceStub.wrapList(children);
    }

    private static Map<String, Object> wrapList(NodeList children) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (int i = 0; i < children.getLength(); ++i) {
            Node c = children.item(i);
            if (c instanceof Element) {
                WebServiceStub.wrapElement(map, (Element)c);
                continue;
            }
            WebServiceStub.wrapTextContent(map, c);
        }
        return map;
    }

    private static void wrapTextContent(Map<String, Object> map, Node c) {
        String text = D.s(c.getTextContent());
        if (text != null) {
            map.put("#text", text);
        }
    }

    private static void wrapElement(Map<String, Object> map, Element e) {
        String key = e.getTagName();
        Object value = WebServiceStub.wrap(e.getChildNodes());
        Object old = map.get(key);
        if (old == null) {
            map.put(key, value);
        } else if (old instanceof List) {
            ((List)old).add(value);
        } else {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(old);
            list.add(value);
            map.put(key, list);
        }
    }

    private String readResponse(InputStream is) throws IOException {
        InputStreamReader reader = new InputStreamReader(is, this.charset);
        StringBuilder sb = new StringBuilder();
        int c = ((Reader)reader).read();
        while (c >= 0) {
            sb.append((char)c);
            c = ((Reader)reader).read();
        }
        return sb.toString();
    }

    private HttpURLConnection send(String method, String data, NetUtil.ConnectionDecorator decorator) throws IOException {
        HttpURLConnection http = this.createConnection();
        byte[] bytes = data.getBytes(this.charset);
        decorator.beforeSubmit(http);
        this.setDefaultProperties(method, http, bytes);
        this.setRequest(http, bytes);
        decorator.afterSubmit(http);
        return http;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRequest(HttpURLConnection http, byte[] bytes) throws IOException {
        try (OutputStream out = http.getOutputStream();){
            out.write(bytes);
            out.flush();
        }
    }

    private void setDefaultProperties(String method, HttpURLConnection http, byte[] bytes) {
        if (D.s(http.getRequestProperty("Content-Type")) == null) {
            http.setRequestProperty("Content-Type", "text/xml; charset=" + this.charset);
        }
        http.setRequestProperty("Content-Length", String.valueOf(bytes.length));
        if (D.s(http.getRequestProperty(SOAP_ACTION)) == null) {
            if (this.isAsmx) {
                http.setRequestProperty(SOAP_ACTION, this.m_domain + method);
            } else {
                http.setRequestProperty(SOAP_ACTION, method);
            }
        }
        http.setConnectTimeout(NetUtil.TIMEOUT);
        http.setReadTimeout(NetUtil.TIMEOUT);
    }

    private HttpURLConnection createConnection() throws IOException {
        URL url = new URL(this.url);
        HttpURLConnection http = (HttpURLConnection)url.openConnection();
        http.setDoOutput(true);
        return http;
    }

    private String generateSoapMessage(String method, Map<String, Object> params) {
        Document doc = Xml.newDocument();
        Element env = doc.createElement("soap:Envelope");
        env.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        env.setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
        env.setAttribute("xmlns:soap", "http://schemas.xmlsoap.org/soap/envelope/");
        doc.appendChild(env);
        Element body = doc.createElement("soap:Body");
        env.appendChild(body);
        Element op = doc.createElement(method);
        op.setAttribute("xmlns", this.m_domain);
        body.appendChild(op);
        WebServiceStub.wrap(op, params, this.isAsmx);
        return Xml.toString(doc);
    }

    public static void wrap(Element root, Map<String, Object> params) {
        for (Map.Entry<String, Object> e : params.entrySet()) {
            WebServiceStub.appendParam(root, e, true);
        }
    }

    private static void wrap(Element root, Map<String, Object> params, boolean isAsmx) {
        for (Map.Entry<String, Object> e : params.entrySet()) {
            WebServiceStub.appendParam(root, e, isAsmx);
        }
    }

    private static void appendParam(Element op, Map.Entry<String, Object> e, boolean isAsmx) {
        Object value = e.getValue();
        if (value == null) {
            return;
        }
        String name = e.getKey();
        if (value instanceof Collection) {
            for (Object item : (Collection)value) {
                WebServiceStub.appendParam(op, name, item, isAsmx);
            }
        } else if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                Object item = Array.get(value, i);
                WebServiceStub.appendParam(op, name, item, isAsmx);
            }
        } else {
            WebServiceStub.appendParam(op, name, value, isAsmx);
        }
    }

    private static void appendParam(Element op, String name, Object value, boolean isAsmx) {
        Element param = op.getOwnerDocument().createElement(name);
        if (!isAsmx) {
            param.setAttribute("xmlns", "");
        }
        op.appendChild(param);
        if (value instanceof Map) {
            for (Map.Entry<String, Object> entry : ((Map)value).entrySet()) {
                WebServiceStub.appendParam(param, entry, isAsmx);
            }
        } else {
            param.setTextContent(D.s(value));
        }
    }
}

