/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.misc.mem;

import java.lang.ref.SoftReference;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kd.ai.gai.dataentity.resource.ResManager;
import kd.ai.gai.flow.dt.D;
import kd.ai.gai.flow.except.OutOfMemoryException;
import kd.ai.gai.flow.misc.mem.ObjectSizeCalculator;
import kd.ai.gai.flow.misc.mem.RuntimeContext;
import kd.ai.gai.flow.script.misc.log.Logger;
import kd.ai.gai.flow.script.misc.log.LoggerFactory;

public class MemoryUtil {
    private static final Logger log;
    private static AtomicInteger loopCount;
    private static volatile State state;
    public static final long OBJECT_SIZE_THRESHOLD;
    public static final long CRITICAL_OBJECT_SIZE_THRESHOLD;
    public static final int LIST_SIZE_THRESHOLD;
    public static final long FREE_MEMORY_THREHOLD;

    public static void clearLast() {
        CollectionMemoryInfo.last.remove();
        ContextMemoryInfo.last.remove();
    }

    public static void checkContextMemorySize(RuntimeContext ctx) throws OutOfMemoryException {
        ContextMemoryInfo last;
        if (ctx.isMemoryControlEnabled() && MemoryUtil.__isCritical() && ((last = ContextMemoryInfo.getLast(ctx)) == null || last.nextCheckpoint <= System.nanoTime())) {
            long bytes = MemoryUtil.calcObjectSizt(ctx);
            MemoryUtil.innerCheckMemorySize(bytes);
            ContextMemoryInfo.setLast(ctx, bytes, last);
        }
    }

    public static void checkCollectionMemorySize(Collection<?> c, RuntimeContext ctx) {
        if (ctx.isMemoryControlEnabled()) {
            if (c instanceof List) {
                MemoryUtil.checkListMemorySize((List)c);
            } else {
                MemoryUtil.checkOtherCollectionMemorySize(c);
            }
        }
    }

    private static boolean __isCritical() {
        if ((loopCount.incrementAndGet() & 0xFF) != 0) {
            return state.critical;
        }
        return state.critical || MemoryUtil.refreshState().critical;
    }

    private static void checkListMemorySize(List<?> c) {
        int length = c.size();
        if (length == LIST_SIZE_THRESHOLD) {
            MemoryUtil.checkListMemorySizeFirstTime(c);
        } else if (length > LIST_SIZE_THRESHOLD) {
            CollectionMemoryInfo last = CollectionMemoryInfo.getLast(c);
            if (last == null) {
                MemoryUtil.checkListMemorySizeWithSampling(c);
            } else {
                MemoryUtil.checkListMemorySizeWithDelta(c, last);
            }
        }
    }

    private static void checkListMemorySizeWithDelta(List<?> c, CollectionMemoryInfo last) {
        if (last.nextCheckpoint == c.size()) {
            long bytes = MemoryUtil.calcObjectSizeWithDelta(c, last);
            MemoryUtil.innerCheckMemorySize(bytes);
            CollectionMemoryInfo.setLast(c, bytes);
        }
    }

    private static void checkListMemorySizeWithSampling(List<?> c) {
        if ((c.size() & 0x3FF) == 0) {
            long bytes = MemoryUtil.calcObjectSizeWithSampling(c);
            MemoryUtil.innerCheckMemorySize(bytes);
            CollectionMemoryInfo.setLast(c, bytes);
        }
    }

    private static void checkListMemorySizeFirstTime(List<?> c) {
        long bytes = MemoryUtil.calcObjectSizeWithSampling(c);
        MemoryUtil.innerCheckMemorySize(bytes);
        CollectionMemoryInfo.setLast(c, bytes);
    }

    private static long calcObjectSizeWithSampling(Collection<?> c) {
        int length = c.size();
        int step = (int)Math.sqrt(length);
        long sampleBytes = 0L;
        int index = 0;
        int sampleCount = 0;
        int expectedIndex = step;
        for (Object e : c) {
            if (++index != expectedIndex) continue;
            sampleBytes += MemoryUtil.calcObjectSizt(e);
            expectedIndex += step;
            ++sampleCount;
        }
        if (sampleCount == 0) {
            return MemoryUtil.calcObjectSizt(c);
        }
        return sampleBytes * (long)length / (long)sampleCount + (long)(ObjectSizeCalculator.REFERENCE_SIZE * length);
    }

    private static long calcObjectSizeWithDelta(List<?> c, CollectionMemoryInfo last) {
        List<?> subList = c.subList(last.lastLength, c.size());
        return last.bytes + MemoryUtil.calcObjectSizeWithSampling(subList);
    }

    private static void checkOtherCollectionMemorySize(Collection<?> c) {
        int length = c.size();
        if ((length & 0x3FFF) == 0 && length >= LIST_SIZE_THRESHOLD) {
            long bytes = MemoryUtil.calcObjectSizeWithSampling(c);
            MemoryUtil.innerCheckMemorySize(bytes);
        }
    }

    private static void innerCheckMemorySize(long bytes) {
        if (bytes >= OBJECT_SIZE_THRESHOLD) {
            log.warn("OUT_OF_OBJECT_SIZE_THRESHOLD @ " + MemoryUtil.now());
            String message = String.format(ResManager.loadKDString("\u5f53\u524d\u4efb\u52a1\u5360\u7528\u5185\u5b58\uff08%1$s\uff09\u5df2\u8fbe\u5230\u6216\u8d85\u8fc7\u4e0a\u9650\uff08%2$s\uff09\uff0c\u4e3a\u964d\u4f4e\u7cfb\u7edfOOM\u98ce\u9669\uff0c\u5f53\u524d\u4efb\u52a1\u7ec8\u6b62\u6267\u884c\u3002", "MemoryUtil_6", "isc-iscb-util", new Object[0]), MemoryUtil.toText(bytes), MemoryUtil.toText(OBJECT_SIZE_THRESHOLD));
            throw new OutOfMemoryException(message);
        }
        if (bytes >= CRITICAL_OBJECT_SIZE_THRESHOLD && MemoryUtil.refreshState().critical) {
            log.warn("OUT_OF_CRITICAL_OBJECT_SIZE_THRESHOLD @ " + MemoryUtil.now());
            String message = String.format(ResManager.loadKDString("\u5f53\u524d\u4efb\u52a1\u5360\u7528\u5185\u5b58\uff08%1$s\uff09\u5df2\u8fbe\u6216\u8d85\u8fc7\u7d27\u6025\u72b6\u6001\u4e0b\u7684\u4e0a\u9650\uff08%2$s\uff09\uff0c\u4e3a\u964d\u4f4e\u7cfb\u7edfOOM\u98ce\u9669\uff0c\u5f53\u524d\u4efb\u52a1\u7ec8\u6b62\u6267\u884c\u3002", "MemoryUtil_7", "isc-iscb-util", new Object[0]), MemoryUtil.toText(bytes), MemoryUtil.toText(CRITICAL_OBJECT_SIZE_THRESHOLD));
            throw new OutOfMemoryException(message);
        }
    }

    private static Timestamp now() {
        return new Timestamp(System.currentTimeMillis());
    }

    private static long calcObjectSizt(Object ctx) {
        try {
            return ObjectSizeCalculator.getObjectSize(ctx);
        }
        catch (Throwable e) {
            String message = ResManager.loadKDString("\u8ba1\u7b97\u5bf9\u8c61\u5360\u7528\u7684\u5185\u5b58\u5927\u5c0f\u65f6\u53d1\u751f\u5f02\u5e38\uff0c\u4e3a\u9632\u6b62\u7cfb\u7edfOOM\uff0c\u5f53\u524d\u4efb\u52a1\u7ec8\u6b62\u6267\u884c\u3002", "MemoryUtil_4", "isc-iscb-util", new Object[0]);
            throw new OutOfMemoryException(message, e);
        }
    }

    private static String toText(long bytes) {
        if (bytes < 1024L) {
            return String.format(ResManager.loadKDString("%s\u5b57\u8282", "MemoryUtil_8", "isc-iscb-util", new Object[0]), bytes);
        }
        if (bytes < 0x100000L) {
            return (bytes >>> 10) + "KB";
        }
        return (bytes >>> 20) + "MB";
    }

    public static boolean isCritical() {
        return state.critical;
    }

    public static State refreshState() {
        long totalMemory;
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        long freeMemory = maxMemory - (totalMemory = runtime.totalMemory()) + runtime.freeMemory();
        boolean critical = FREE_MEMORY_THREHOLD > freeMemory;
        state = new State(freeMemory, critical);
        return state;
    }

    static {
        int list_threshold;
        long free_memory_threshold;
        long critical_ctx_threshold;
        long ctx_threshold;
        log = LoggerFactory.REF.get().getLogger(MemoryUtil.class);
        loopCount = new AtomicInteger();
        state = new State(Long.MAX_VALUE, false);
        try {
            String s = System.getProperty("OBJECT_SIZE_THRESHOLD");
            ctx_threshold = s != null ? D.l((Object)s) * 1024L * 1024L : Runtime.getRuntime().maxMemory() / 3L;
        }
        catch (Throwable e) {
            ctx_threshold = 0x10000000L;
        }
        OBJECT_SIZE_THRESHOLD = ctx_threshold;
        try {
            String s = System.getProperty("CRITICAL_OBJECT_SIZE_THRESHOLD");
            critical_ctx_threshold = s != null ? D.l((Object)s) * 1024L * 1024L : Runtime.getRuntime().maxMemory() / 7L;
        }
        catch (Throwable e) {
            critical_ctx_threshold = 0x4000000L;
        }
        CRITICAL_OBJECT_SIZE_THRESHOLD = critical_ctx_threshold;
        try {
            String s = System.getProperty("FREE_MEMORY_THREHOLD");
            free_memory_threshold = s != null ? D.l((Object)s) * 1024L * 1024L : (long)((double)Runtime.getRuntime().maxMemory() * 0.2);
        }
        catch (Throwable e) {
            free_memory_threshold = 0x10000000L;
        }
        FREE_MEMORY_THREHOLD = free_memory_threshold;
        try {
            String s = System.getProperty("LIST_LENGTH_THRESHOLD");
            list_threshold = s != null ? Math.max(128, D.i((Object)s)) : Math.max(128, (int)(Runtime.getRuntime().maxMemory() / 0x100000L));
        }
        catch (Throwable e) {
            list_threshold = 1024;
        }
        LIST_SIZE_THRESHOLD = list_threshold;
    }

    private static class ContextMemoryInfo {
        private static final ThreadLocal<SoftReference<ContextMemoryInfo>> last = new ThreadLocal();
        private Object ctx;
        private long bytes;
        private long lastTime;
        private long nextCheckpoint;

        private ContextMemoryInfo(Object ctx, long bytes, ContextMemoryInfo prior) {
            this.ctx = ctx;
            this.bytes = bytes;
            this.nextCheckpoint = this.lastTime = System.nanoTime();
            long lastTime = this.lastTime;
            if (prior == null) {
                return;
            }
            long bytesDiff = bytes - prior.bytes;
            if (bytesDiff != 0L) {
                long timeDiff = lastTime - prior.lastTime;
                long delta = Math.min(CRITICAL_OBJECT_SIZE_THRESHOLD - bytes, state.freeMemory >> 3);
                long step = Math.min(9000000000L, Math.max(0L, delta * timeDiff / bytesDiff >>> 1));
                this.nextCheckpoint = lastTime + step;
            }
        }

        private static void setLast(Object ctx, long bytes, ContextMemoryInfo prior) {
            last.set(new SoftReference<ContextMemoryInfo>(new ContextMemoryInfo(ctx, bytes, prior)));
        }

        private static ContextMemoryInfo getLast(Object ctx) {
            SoftReference<ContextMemoryInfo> ref = last.get();
            if (ref == null) {
                return null;
            }
            ContextMemoryInfo m = ref.get();
            if (m != null && m.ctx == ctx) {
                return m;
            }
            return null;
        }
    }

    private static class CollectionMemoryInfo {
        private static final ThreadLocal<SoftReference<CollectionMemoryInfo>> last = new ThreadLocal();
        private Collection<?> c;
        private int lastLength;
        private long bytes;
        private int nextCheckpoint;

        private static CollectionMemoryInfo getLast(Collection<?> c) {
            SoftReference<CollectionMemoryInfo> ref = last.get();
            if (ref == null) {
                return null;
            }
            CollectionMemoryInfo m = ref.get();
            if (m != null && m.c == c && m.lastLength <= c.size()) {
                return m;
            }
            return null;
        }

        private static void setLast(Collection<?> c, long bytes) {
            last.set(new SoftReference<CollectionMemoryInfo>(new CollectionMemoryInfo(c, bytes)));
        }

        private CollectionMemoryInfo(Collection<?> c, long bytes) {
            this.c = c;
            this.bytes = bytes;
            int length = this.lastLength = c.size();
            long delta = Math.min(OBJECT_SIZE_THRESHOLD - bytes, state.freeMemory >> 2);
            int diff = (int)(delta * (long)length / bytes);
            int step = Math.max(1, Math.min(diff >>> 1, LIST_SIZE_THRESHOLD));
            this.nextCheckpoint = length + step;
        }
    }

    private static class State {
        private long freeMemory;
        private boolean critical;

        public State(long freeMemory, boolean critical) {
            this.freeMemory = freeMemory;
            this.critical = critical;
        }
    }
}

