/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.misc.mem;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import kd.ai.gai.dataentity.resource.ResManager;
import kd.ai.gai.flow.misc.mem.ClassFilter;
import kd.ai.gai.flow.misc.mem.ClassSizeInfo;
import kd.ai.gai.flow.misc.mem.ObjectSizeIgnored;
import kd.ai.gai.flow.misc.mem.c.ArrayClassSizeInfo;
import kd.ai.gai.flow.misc.mem.c.AtomicClassSizeInfo;
import kd.ai.gai.flow.misc.mem.c.BigDecimalClassSizeInfo;
import kd.ai.gai.flow.misc.mem.c.BigIntegerClassSizeInfo;
import kd.ai.gai.flow.misc.mem.c.BinaryStringClassSizeInfo;
import kd.ai.gai.flow.misc.mem.c.IgnoredClassSizeInfo;
import kd.ai.gai.flow.misc.mem.c.ListClassSizeInfo;
import kd.ai.gai.flow.misc.mem.c.MapClassSizeInfo;
import kd.ai.gai.flow.misc.mem.c.SetClassSizeInfo;
import kd.ai.gai.flow.misc.mem.c.StringClassSizeInfo;
import kd.ai.gai.flow.script.data.BinaryString;

public final class ObjectSizeCalculator {
    private long size = 0L;
    private IdentityHashMap<Object, Boolean> visited = new IdentityHashMap(511);
    public static final int ARRAY_HEADER_SIZE;
    public static final int OBJECT_HEADER_SIZE;
    public static final int OBJECT_PADDING;
    public static final int REFERENCE_SIZE;
    public static final int SUPERCLASS_FIELD_PADDING;
    private static final ConcurrentHashMap<Class<?>, ClassSizeInfo> classSizeInfoMap;
    private static volatile List<ClassFilter> filters;

    public static long getObjectSize(Object obj) throws UnsupportedOperationException {
        return new ObjectSizeCalculator().calculateObjectSize(obj);
    }

    private ObjectSizeCalculator() {
    }

    private long calculateObjectSize(Object obj) {
        this.visit(obj, 0);
        return this.size;
    }

    public void visit(Object obj, int level) {
        if (obj != null) {
            Class<?> clazz = obj.getClass();
            ClassSizeInfo classSizeInfo = ObjectSizeCalculator.getClassSizeInfo(clazz);
            classSizeInfo.visit(obj, this, level);
        }
    }

    public void checkLevel(int level) {
        if (level > 64) {
            throw new UnsupportedOperationException(ResManager.loadKDString("\u5bf9\u8c61\u5185\u90e8\u7684\u5f15\u7528\u5c42\u6b21\u5d4c\u5957\u592a\u6df1\u6216\u5b58\u5728\u9012\u5f52\u5f15\u7528\u3002", "ObjectSizeCalculator_0", "isc-iscb-util", new Object[0]));
        }
    }

    public void increaseSize(long objectSize) {
        this.size += objectSize;
    }

    public static long roundTo(long x, int multiple) {
        return (x + (long)multiple - 1L) / (long)multiple * (long)multiple;
    }

    public static long getPrimitiveFieldSize(Class<?> type) {
        if (type == Boolean.TYPE || type == Byte.TYPE) {
            return 1L;
        }
        if (type == Character.TYPE || type == Short.TYPE) {
            return 2L;
        }
        if (type == Integer.TYPE || type == Float.TYPE) {
            return 4L;
        }
        if (type == Long.TYPE || type == Double.TYPE) {
            return 8L;
        }
        throw new AssertionError((Object)("Encountered unexpected primitive type " + type.getName()));
    }

    public boolean addVisited(Object obj) {
        return this.visited.put(obj, Boolean.TRUE) == null;
    }

    private static ClassSizeInfo getClassSizeInfo(Class<?> clazz) {
        ClassSizeInfo csi = classSizeInfoMap.get(clazz);
        if (csi != null) {
            return csi;
        }
        if (clazz.isArray()) {
            classSizeInfoMap.putIfAbsent(clazz, new ArrayClassSizeInfo(clazz));
        } else if (java.util.Date.class.isAssignableFrom(clazz)) {
            classSizeInfoMap.putIfAbsent(clazz, new AtomicClassSizeInfo(clazz));
        } else if (CharSequence.class.isAssignableFrom(clazz)) {
            classSizeInfoMap.putIfAbsent(clazz, new StringClassSizeInfo(clazz));
        } else if (ObjectSizeCalculator.isIgnored(clazz)) {
            classSizeInfoMap.putIfAbsent(clazz, new IgnoredClassSizeInfo(clazz));
        } else if (List.class.isAssignableFrom(clazz)) {
            classSizeInfoMap.putIfAbsent(clazz, new ListClassSizeInfo(clazz));
        } else if (Map.class.isAssignableFrom(clazz)) {
            classSizeInfoMap.putIfAbsent(clazz, new MapClassSizeInfo(clazz));
        } else {
            classSizeInfoMap.putIfAbsent(clazz, new IgnoredClassSizeInfo(clazz));
        }
        return classSizeInfoMap.get(clazz);
    }

    private static boolean isIgnored(Class<?> clazz) {
        if (ObjectSizeIgnored.class.isAssignableFrom(clazz)) {
            return true;
        }
        for (ClassFilter filter : filters) {
            if (!filter.isIgnored(clazz)) continue;
            return true;
        }
        return false;
    }

    public static synchronized void registerFilter(ClassFilter filter) {
        ArrayList<ClassFilter> list = new ArrayList<ClassFilter>(filters);
        list.add(filter);
        filters = list;
    }

    static {
        long max = Runtime.getRuntime().maxMemory();
        if (max < 0x780000000L) {
            ARRAY_HEADER_SIZE = 16;
            OBJECT_HEADER_SIZE = 12;
            OBJECT_PADDING = 8;
            REFERENCE_SIZE = 4;
            SUPERCLASS_FIELD_PADDING = 4;
        } else {
            ARRAY_HEADER_SIZE = 24;
            OBJECT_HEADER_SIZE = 16;
            OBJECT_PADDING = 8;
            REFERENCE_SIZE = 8;
            SUPERCLASS_FIELD_PADDING = 8;
        }
        classSizeInfoMap = new ConcurrentHashMap();
        classSizeInfoMap.put(Object.class, new AtomicClassSizeInfo(Object.class));
        classSizeInfoMap.put(Byte.class, new AtomicClassSizeInfo(Byte.class));
        classSizeInfoMap.put(Short.class, new AtomicClassSizeInfo(Short.class));
        classSizeInfoMap.put(Integer.class, new AtomicClassSizeInfo(Integer.class));
        classSizeInfoMap.put(Long.class, new AtomicClassSizeInfo(Long.class));
        classSizeInfoMap.put(Float.class, new AtomicClassSizeInfo(Float.class));
        classSizeInfoMap.put(Double.class, new AtomicClassSizeInfo(Double.class));
        classSizeInfoMap.put(Boolean.class, new AtomicClassSizeInfo(Boolean.class));
        classSizeInfoMap.put(Character.class, new AtomicClassSizeInfo(Character.class));
        classSizeInfoMap.put(java.util.Date.class, new AtomicClassSizeInfo(java.util.Date.class));
        classSizeInfoMap.put(Date.class, new AtomicClassSizeInfo(Date.class));
        classSizeInfoMap.put(Timestamp.class, new AtomicClassSizeInfo(Timestamp.class));
        classSizeInfoMap.put(Time.class, new AtomicClassSizeInfo(Time.class));
        classSizeInfoMap.put(BinaryString.class, new BinaryStringClassSizeInfo());
        classSizeInfoMap.put(BigInteger.class, new BigIntegerClassSizeInfo());
        classSizeInfoMap.put(BigDecimal.class, new BigDecimalClassSizeInfo());
        classSizeInfoMap.put(String.class, new StringClassSizeInfo(String.class));
        classSizeInfoMap.put(StringBuilder.class, new StringClassSizeInfo(StringBuilder.class));
        classSizeInfoMap.put(StringBuffer.class, new StringClassSizeInfo(StringBuffer.class));
        classSizeInfoMap.put(LinkedList.class, new ListClassSizeInfo(LinkedList.class));
        classSizeInfoMap.put(ArrayList.class, new ListClassSizeInfo(ArrayList.class));
        classSizeInfoMap.put(HashMap.class, new MapClassSizeInfo(HashMap.class));
        classSizeInfoMap.put(LinkedHashMap.class, new MapClassSizeInfo(LinkedHashMap.class));
        classSizeInfoMap.put(TreeMap.class, new MapClassSizeInfo(TreeMap.class));
        classSizeInfoMap.put(HashSet.class, new SetClassSizeInfo(HashSet.class));
        classSizeInfoMap.put(LinkedHashSet.class, new SetClassSizeInfo(LinkedHashSet.class));
        classSizeInfoMap.put(TreeSet.class, new SetClassSizeInfo(TreeSet.class));
        filters = new ArrayList<ClassFilter>();
    }
}

