/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.mock;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.Proxy;
import java.net.URL;
import java.net.URLStreamHandler;
import java.util.Hashtable;
import kd.ai.gai.flow.dt.D;
import kd.ai.gai.flow.mock.HttpMockConnection;
import kd.ai.gai.flow.mock.HttpMockStub;

public class HttpMock {
    public static final String PROTOCAL = "iscmock";
    private static ThreadLocal<HttpMockStub> stub = new ThreadLocal();

    public static void begin(HttpMockStub stub) {
        if (HttpMock.stub.get() != null) {
            throw new UnsupportedOperationException("Stub is set.");
        }
        HttpMock.stub.set(stub);
    }

    public static void end() {
        stub.remove();
    }

    private static void init() throws NoSuchFieldException, IllegalAccessException {
        Field f = URL.class.getDeclaredField("handlers");
        f.setAccessible(true);
        Hashtable handlers = (Hashtable)f.get(null);
        handlers.put(PROTOCAL, new URLStreamHandler(){

            @Override
            protected HttpMockConnection openConnection(URL u) throws IOException {
                HttpMockStub stub = (HttpMockStub)stub.get();
                if (stub != null) {
                    return new HttpMockConnection(u, stub);
                }
                throw new UnsupportedOperationException("Stub not exists.");
            }

            @Override
            protected HttpMockConnection openConnection(URL u, Proxy p) throws IOException {
                return this.openConnection(u);
            }
        });
    }

    static {
        try {
            HttpMock.init();
        }
        catch (Exception e) {
            throw D.e(e);
        }
    }
}

