/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.mock;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.flow.dt.D;
import kd.ai.gai.flow.script.Script;

public class HttpMockRequest {
    private String method;
    private Map<String, List<String>> properties = new LinkedHashMap<String, List<String>>();
    private URL url;
    private ByteArrayOutputStream data;

    HttpMockRequest(URL url) {
        this.url = url;
    }

    void setRequestMethod(String method) {
        this.method = method;
    }

    void setRequestProperty(String key, String value) {
        List<String> values = this.properties.get(key);
        if (values == null) {
            values = new ArrayList<String>(1);
            this.properties.put(key, values);
        }
        values.add(value);
    }

    OutputStream getOutputStream() {
        ByteArrayOutputStream data = this.data;
        if (data == null) {
            data = this.data = new ByteArrayOutputStream();
        }
        return data;
    }

    public String getQueryString() {
        String url = this.url.toString();
        int i = url.indexOf(63);
        return i < 0 ? "" : url.substring(i + 1);
    }

    public String getRequestURI() {
        String url = this.url.toString();
        int i = url.indexOf("//");
        int j = url.indexOf(63);
        if (j < 0) {
            return url.substring(i + 2);
        }
        return url.substring(i + 2, j);
    }

    public URL getUrl() {
        return this.url;
    }

    public String getMethod() {
        return this.method;
    }

    public byte[] getData() {
        return this.data == null ? null : this.data.toByteArray();
    }

    public String getTextData() {
        return new String(this.data.toByteArray(), D.UTF_8);
    }

    public Object getJsonData() {
        return Script.parseJson(new String(this.data.toByteArray(), D.UTF_8));
    }

    public Map<String, List<String>> getHeaders() {
        return this.properties;
    }

    public String getHeader(String key) {
        List<String> values = this.properties.get(key);
        if (values == null) {
            return null;
        }
        return values.get(values.size() - 1);
    }
}

