/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.mock;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.flow.err.CommonError;
import kd.ai.gai.flow.misc.Pair;

public class HttpMockResponse {
    private static final String UTF_8 = "UTF-8";
    private byte[] data;
    private int responseCode;
    private List<Map.Entry<String, String>> headers = new ArrayList<Map.Entry<String, String>>(16);

    public HttpMockResponse(int responseCode) {
        this(responseCode, new byte[0]);
    }

    public HttpMockResponse(int responseCode, byte[] data) {
        this(responseCode, data, new HashMap<String, String>(1), new HashMap<String, String>(1));
    }

    public HttpMockResponse(int responseCode, byte[] data, Map<String, String> cookies, Map<String, String> headers) {
        assert (data != null);
        this.data = data;
        this.responseCode = responseCode;
        this.headers.addAll(headers.entrySet());
        this.setCookies(cookies);
    }

    private void setCookies(Map<String, String> cookies) {
        try {
            for (Map.Entry<String, String> e : cookies.entrySet()) {
                this.headers.add(new Pair<String, String>("Set-Cookie", e.getKey() + "=" + URLEncoder.encode(e.getValue(), UTF_8) + "; Path=/; HttpOnly"));
            }
        }
        catch (IOException e) {
            throw CommonError.INVALID_CHARSET.create(e, UTF_8);
        }
    }

    public InputStream getInputStream() {
        if (this.responseCode < 300) {
            return new ByteArrayInputStream(this.data);
        }
        throw new UnsupportedOperationException(String.valueOf(this.responseCode));
    }

    public InputStream getErrorStream() {
        if (this.responseCode >= 400) {
            return new ByteArrayInputStream(this.data);
        }
        throw new UnsupportedOperationException(String.valueOf(this.responseCode));
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getHeaderFieldKey(int n) {
        if (n == 0) {
            return null;
        }
        if (n <= this.headers.size()) {
            return this.headers.get(n - 1).getKey();
        }
        return null;
    }

    public String getHeaderField(int n) {
        if (n == 0) {
            return "1.1; " + this.responseCode + "; ";
        }
        if (n <= this.headers.size()) {
            return this.headers.get(n - 1).getValue();
        }
        return null;
    }

    public Map<String, List<String>> getHeaderFields() {
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>(this.headers.size());
        for (Map.Entry<String, String> e : this.headers) {
            List<String> values = map.get(e.getKey());
            if (values == null) {
                values = new ArrayList<String>(1);
                map.put(e.getKey(), values);
            }
            values.add(e.getValue());
        }
        return map;
    }
}

