/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.network;

import java.net.InetAddress;
import kd.ai.gai.dataentity.resource.ResManager;
import kd.ai.gai.flow.except.IscBizException;
import kd.ai.gai.flow.misc.StringUtil;
import kd.ai.gai.flow.network.CheckBean;
import kd.ai.gai.flow.network.CheckNetWorkUtil;
import kd.ai.gai.flow.network.CheckNetwork;
import kd.ai.gai.flow.network.CheckResult;

public class SimplePing
implements CheckNetwork {
    protected static final SimplePing INSTANCE = new SimplePing();
    private static final int MAX_NUM = 5;

    private SimplePing() {
    }

    @Override
    public CheckResult check(CheckBean checkBean) {
        if (StringUtil.isEmpty(checkBean.getIpOrHostName())) {
            throw new IscBizException(ResManager.loadKDString("ip\u6216\u57df\u540d\u4e3a\u7a7a", "SimplePing_0", "isc-iscb-util", new Object[0]));
        }
        long start = System.currentTimeMillis();
        return this.executeSimple(checkBean, start);
    }

    private CheckResult executeSimple(CheckBean checkBean, long start) {
        try {
            InetAddress inetAddress = InetAddress.getByName(checkBean.getIpOrHostName());
            StringBuilder sb = new StringBuilder();
            sb.append(String.format(ResManager.loadKDString("%s \u7684 Ping \u7edf\u8ba1\u4fe1\u606f:", "SimplePing_7", "isc-iscb-util", new Object[0]), inetAddress.getHostAddress())).append("\r\n");
            for (int i = 1; i <= 5; ++i) {
                long eachStart = System.currentTimeMillis();
                boolean reachable = inetAddress.isReachable(checkBean.getTimeout());
                long span = System.currentTimeMillis() - eachStart;
                if (reachable) {
                    sb.append(String.format(ResManager.loadKDString("\u7b2c %1$s \u6b21 PING %2$s \u6210\u529f\uff0c\u8017\u65f6\uff1a%3$sms", "SimplePing_4", "isc-iscb-util", new Object[0]), i, inetAddress.getHostAddress(), span));
                } else {
                    sb.append(String.format(ResManager.loadKDString("\u7b2c %1$s \u6b21 PING %2$s \u5931\u8d25\uff0c\u8017\u65f6\uff1a%3$sms", "SimplePing_5", "isc-iscb-util", new Object[0]), i, inetAddress.getHostAddress(), span));
                }
                sb.append("\r\n");
            }
            return new CheckResult(true, sb.toString(), start);
        }
        catch (Exception e) {
            return new CheckResult(false, CheckNetWorkUtil.toString(e), start);
        }
    }
}

