/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.network;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import kd.ai.gai.dataentity.resource.ResManager;
import kd.ai.gai.flow.db.DbUtil;
import kd.ai.gai.flow.except.IscBizException;
import kd.ai.gai.flow.misc.StringUtil;
import kd.ai.gai.flow.network.CheckBean;
import kd.ai.gai.flow.network.CheckNetWorkUtil;
import kd.ai.gai.flow.network.CheckNetwork;
import kd.ai.gai.flow.network.CheckResult;

public class SimpleTelnet
implements CheckNetwork {
    protected static final SimpleTelnet INSTANCE = new SimpleTelnet();

    private SimpleTelnet() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CheckResult check(CheckBean checkBean) {
        if (StringUtil.isEmpty(checkBean.getIpOrHostName())) {
            throw new IscBizException(ResManager.loadKDString("ip\u6216\u57df\u540d\u4e3a\u7a7a", "SimpleTelnet_0", "isc-iscb-util", new Object[0]));
        }
        if (checkBean.getPort() <= 0) {
            throw new IscBizException(ResManager.loadKDString("\u7f51\u7edc\u7aef\u53e3\u4e0d\u5408\u6cd5", "SimpleTelnet_1", "isc-iscb-util", new Object[0]));
        }
        long start = System.currentTimeMillis();
        Socket socket = null;
        try {
            socket = new Socket();
            InetSocketAddress address = new InetSocketAddress(checkBean.getIpOrHostName(), checkBean.getPort());
            socket.connect(address, checkBean.getTimeout());
            CheckResult checkResult = new CheckResult(true, start);
            return checkResult;
        }
        catch (Exception e) {
            CheckResult checkResult = new CheckResult(false, CheckNetWorkUtil.toString(e), start);
            return checkResult;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException ignore) {
                    DbUtil.getLogger().error("kd.ai.gai.flow.network.SimpleTelnet.check(CheckBean)", ignore);
                }
            }
        }
    }
}

