/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import kd.ai.gai.dataentity.resource.ResManager;
import kd.ai.gai.flow.dt.D;
import kd.ai.gai.flow.err.CommonError;
import kd.ai.gai.flow.misc.mem.DisableMemoryControl;
import kd.ai.gai.flow.misc.mem.EnableMemoryControl;
import kd.ai.gai.flow.misc.mem.ObjectSize;
import kd.ai.gai.flow.misc.mem.ObjectSizeIgnored;
import kd.ai.gai.flow.script.BreakpointManager;
import kd.ai.gai.flow.script.JsonScriptContext;
import kd.ai.gai.flow.script.LifeScriptContext;
import kd.ai.gai.flow.script.LifeScriptEngine;
import kd.ai.gai.flow.script.LifeScriptEngineFactory;
import kd.ai.gai.flow.script.ScriptBinding;
import kd.ai.gai.flow.script.context.ArrayContext;
import kd.ai.gai.flow.script.context.Context;
import kd.ai.gai.flow.script.core.Identifier;
import kd.ai.gai.flow.script.core.Statement;
import kd.ai.gai.flow.script.core.Storer;
import kd.ai.gai.flow.script.misc.AES_ECB_PKCS5;
import kd.ai.gai.flow.script.misc.AES_ECB_PKCS5_Decrypt;
import kd.ai.gai.flow.script.misc.Base64Decode;
import kd.ai.gai.flow.script.misc.Base64Encode;
import kd.ai.gai.flow.script.misc.JwkToRSAPrivateKey;
import kd.ai.gai.flow.script.parser.Program;

public class Script
implements ObjectSizeIgnored {
    private Program program;
    private static final LifeScriptEngine engine;
    private static final LifeScriptEngine simpleEngine;

    public static synchronized void register(Identifier obj) {
        engine.register(obj);
    }

    public static synchronized void registerSimpleEngine(Identifier obj) {
        simpleEngine.register(obj);
    }

    public static synchronized void register(String name, Object obj) {
        engine.register(name, obj);
    }

    public static synchronized void register(Class<?> cls) {
        engine.register(cls.getSimpleName(), cls);
    }

    public static Script compile(String text) {
        return new Script(engine.compile(text));
    }

    public static Script compile(String text, Map<String, Object> context) {
        return new Script(engine.compile(text, context));
    }

    public static Script compile(String text, String resId, Map<String, Object> context) {
        return new Script(engine.compile(text, resId, context));
    }

    public static Script compileSimpleScript(String text) {
        return new Script(simpleEngine.compile(text));
    }

    public static Script compileSimpleScript(String text, Map<String, Object> ctx) {
        return new Script(simpleEngine.compile(text, ctx));
    }

    public static Script compileSimpleScript(Reader reader) throws ScriptException {
        return new Script(simpleEngine.compile(reader));
    }

    public static Script compile(Reader reader) throws ScriptException {
        return new Script(engine.compile(reader));
    }

    public static Script compile(Reader reader, Map<String, Object> context) throws ScriptException {
        return new Script(engine.compile(reader, context));
    }

    public static Object parseJson(Reader reader) {
        return simpleEngine.parseJson(reader);
    }

    public static Object parseOnly(Reader reader, Map<String, Object> ctx) throws ScriptException {
        return engine.parseOnly(reader, ctx);
    }

    public static Object parseJson(File file) {
        if (!file.exists()) {
            return null;
        }
        try {
            return Script.read(file);
        }
        catch (IOException e) {
            throw CommonError.INPUT_READER_FAILURE.wrap(e);
        }
    }

    private static Object read(File file) throws IOException {
        try (InputStreamReader fis = new InputStreamReader((InputStream)new FileInputStream(file), D.UTF_8);){
            Object object = Script.parseJson(fis);
            return object;
        }
    }

    public static Object parseJson(String script) {
        try {
            return simpleEngine.parseJson(script);
        }
        catch (ScriptException e) {
            throw D.e(e);
        }
    }

    private Script(Program program) {
        this.program = program;
    }

    public Storer asSetter() {
        Object o = this.program.getImpl();
        if (o instanceof Statement) {
            Statement s = (Statement)o;
            if (s.length() == 1) {
                return (Storer)s.get(0);
            }
        } else if (o instanceof Storer) {
            return (Storer)o;
        }
        throw new UnsupportedOperationException(ResManager.loadKDString("\u811a\u672c\u4e0d\u80fd\u8f6c\u6362\u4e3aStorer\u5bf9\u8c61\uff01", "Script_1", "isc-iscb-util", new Object[0]) + "\r\n" + String.format(ResManager.loadKDString("\u811a\u672c\u662f\uff1a%s", "Script_2", "isc-iscb-util", new Object[0]), o));
    }

    public void setTimeout(int timeout) {
        this.program.setTimeout(timeout);
    }

    public Program getProgram() {
        return this.program;
    }

    public Object eval() {
        return this.eval(ScriptBinding.getBindings());
    }

    public static ScriptContext getScriptContext(Context ctx) {
        return new LifeScriptContext(new ScriptBinding(ctx));
    }

    public Object eval(Context ctx) {
        return this.eval(new ScriptBinding(ctx));
    }

    public Object eval(Object[] params) {
        return this.eval(new ArrayContext(params));
    }

    public Object eval(Map<String, Object> params) {
        return this.eval(new LifeScriptContext(params));
    }

    public Object eval(ScriptBinding binding) {
        return this.eval(new LifeScriptContext(binding));
    }

    public Object evalJson() {
        return this.eval(new JsonScriptContext());
    }

    public Object eval(ScriptContext ctx) {
        Program program = this.program;
        BreakpointManager.REF.get().attachBreakpoints(program);
        return program.eval(ctx);
    }

    public String toString() {
        return this.program.toString();
    }

    static {
        LifeScriptEngineFactory fac = new LifeScriptEngineFactory();
        engine = fac.getScriptEngine();
        simpleEngine = fac.getSimpleScriptEngine();
        if (!"true".equalsIgnoreCase(System.getProperty("ISC_DISABLE_AES_ECB_PKCS5"))) {
            Script.register(new AES_ECB_PKCS5());
            Script.register(new AES_ECB_PKCS5_Decrypt());
        }
        Script.register(new Base64Decode());
        Script.register(new Base64Encode());
        Script.register(new JwkToRSAPrivateKey());
        Script.register("VARCHAR", 12);
        Script.register("VARBINARY", -3);
        Script.register("NVARCHAR", -9);
        Script.register("CHAR", 1);
        Script.register("NCHAR", -15);
        Script.register("DOUBLE", 8);
        Script.register("BINARY", -2);
        Script.register("BLOB", 2004);
        Script.register("CLOB", 2005);
        Script.register("NCLOB", 2011);
        Script.register("BIT", -7);
        Script.register("BIGINT", -5);
        Script.register("INTEGER", 4);
        Script.register("DECIMAL", 3);
        Script.register("TIMESTAMP", 93);
        Script.register("DATETIME", 93);
        Script.register(new ObjectSize());
        Script.register(new EnableMemoryControl());
        Script.register(new DisableMemoryControl());
    }
}

