/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import kd.ai.gai.dataentity.resource.ResManager;
import kd.ai.gai.exception.ErrorCode;
import kd.ai.gai.flow.err.CommonError;
import kd.ai.gai.flow.except.IscBizException;
import kd.ai.gai.flow.script.LifeScriptContext;
import kd.ai.gai.flow.script.LifeScriptEngine;
import kd.ai.gai.flow.script.analyzer.expr.ListConstructor;
import kd.ai.gai.flow.script.core.Constructor;
import kd.ai.gai.flow.script.core.Evaluator;
import kd.ai.gai.flow.script.core.NativeFunction;
import kd.ai.gai.flow.script.core.Reference;
import kd.ai.gai.flow.script.core.Statement;
import kd.ai.gai.flow.script.data.Nullable;
import kd.ai.gai.flow.script.feature.control.advanced.Debuggable;
import kd.ai.gai.flow.script.parser.Undefined;
import kd.ai.gai.flow.script.statement.Arguments;
import kd.ai.gai.flow.script.statement.Invocation;
import kd.ai.gai.flow.script.util.Symbol;

public final class Util {
    public static final String DISABLE_REG_EXPR_CHECK = "#DISABLE_REG_EXPR_CHECK";
    private static final int SCOPE = 100;
    private static volatile Field detailMessage;
    private static volatile boolean omitted;
    private static volatile Field codeMessage;
    private static volatile boolean omitted2;

    public static boolean test(Object condition, ScriptContext ctx) {
        Object f = Util.eval(ctx, condition);
        return Util.objectToBoolean(f);
    }

    public static int find(Object[] args, Class<?> type) {
        for (int i = 0; i < args.length; ++i) {
            if (!type.isInstance(args[i])) continue;
            return i;
        }
        return -1;
    }

    public static int find(List<?> args, Class<?> type) {
        for (int i = 0; i < args.size(); ++i) {
            if (!type.isInstance(args.get(i))) continue;
            return i;
        }
        return -1;
    }

    public static int find(Statement smt, Class<?> type) {
        for (int i = 0; i < smt.length(); ++i) {
            if (!type.isInstance(smt.get(i))) continue;
            return i;
        }
        return -1;
    }

    public static void copy(Object[] src, Object[] dest, int excludeIndex) {
        if (excludeIndex == 0) {
            System.arraycopy(src, 1, dest, 0, dest.length);
        } else if (excludeIndex == dest.length) {
            System.arraycopy(src, 0, dest, 0, dest.length);
        } else {
            System.arraycopy(src, 0, dest, 0, excludeIndex);
            System.arraycopy(src, excludeIndex + 1, dest, excludeIndex, dest.length - excludeIndex);
        }
    }

    public static void copy(Collection<?> src, Object[] dest, int excludeIndex) {
        int i = 0;
        int j = 0;
        for (Object o : src) {
            if (i != excludeIndex) {
                dest[j++] = o;
            }
            ++i;
        }
    }

    public static void set(ScriptContext ctx, String name, Object value) {
        ctx.setAttribute(name, value, 100);
    }

    public static Object get(ScriptContext ctx, String name) {
        return ctx.getAttribute(name, 100);
    }

    public static Object get(String name, Map<String, Object> context, LifeScriptEngine engine) {
        Object value = context.get(name);
        if (value != null) {
            return value;
        }
        value = engine.get(name);
        if (value != null) {
            return value;
        }
        return Util.createReference(name, context);
    }

    public static Object createReference(String name, Map<String, Object> context) {
        Reference r = Reference.create(name);
        context.put(name, r);
        return r;
    }

    public static Object eval(ScriptContext ctx, Object el) {
        if (el instanceof Evaluator) {
            try {
                return ((Evaluator)el).eval(ctx);
            }
            catch (Throwable e) {
                String s = e.getMessage();
                if ((s == null || !s.startsWith("  ")) && el instanceof Debuggable) {
                    int line = ((Debuggable)el).line();
                    Util.rewrite(el, e, line);
                }
                throw CommonError.SCRIPT_RUNTIME_ERROR.wrap(e);
            }
        }
        return el;
    }

    public static void rewrite(Object el, Throwable e, int line) {
        StackTraceElement[] stackTrace = e.getStackTrace();
        if (stackTrace.length == 0) {
            return;
        }
        String className = ResManager.loadKDString("\u811a\u672c", "Util_12", "isc-iscb-util", new Object[0]);
        String fileName = ResManager.loadKDString("\u884c\u53f7", "Util_13", "isc-iscb-util", new Object[0]);
        StackTraceElement trace = stackTrace[0];
        if (className.equals(trace.getClassName()) && fileName.equals(trace.getFileName())) {
            return;
        }
        String method = el.toString();
        for (int i = 0; i < method.length(); ++i) {
            if (!Symbol.isSeperator(method.charAt(i))) continue;
            if (i <= 0) break;
            method = method.substring(0, i);
            break;
        }
        StackTraceElement[] rewrited = new StackTraceElement[stackTrace.length + 1];
        rewrited[0] = new StackTraceElement(className, method, fileName, line);
        System.arraycopy(stackTrace, 0, rewrited, 1, stackTrace.length);
        e.setStackTrace(rewrited);
    }

    public static Object[] evalArray(ScriptContext ctx, Object[] array) {
        int length = array.length;
        Object[] values = new Object[length];
        for (int i = 0; i < length; ++i) {
            values[i] = Util.eval(ctx, array[i]);
        }
        return values;
    }

    public static Object evalList(ScriptContext ctx, Object el) {
        if (el instanceof Invocation) {
            Invocation iv = (Invocation)el;
            if (iv.length() < 2) {
                return iv.eval(ctx);
            }
            Object fn = Util.eval(ctx, iv.get(0));
            if (fn instanceof NativeFunction) {
                return Invocation.call(ctx, (NativeFunction)fn, iv);
            }
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(fn);
            for (int i = 1; i < iv.length(); ++i) {
                list.add(Util.eval(ctx, iv.get(i)));
            }
            return list;
        }
        if (el instanceof Evaluator) {
            return ((Evaluator)el).eval(ctx);
        }
        return el;
    }

    public static Object unwrap(Object e) {
        Object first;
        Arguments s;
        if (e instanceof Arguments && (s = (Arguments)e).length() == 1 && s.terminator() != null && !((first = s.get(0)) instanceof ListConstructor)) {
            return first;
        }
        return e;
    }

    public static Object getElement(Statement statement, Constructor.Position pos, int index) {
        Object el = pos.getOperand(statement, index);
        el = Util.unwrap(el);
        return el;
    }

    public static Object getElement(Statement statement, int index) {
        Object el = statement.get(index);
        el = Util.unwrap(el);
        return el;
    }

    public static Object getTail(Statement statement, Constructor.Position pos, int start) throws ScriptException {
        int len = statement.length() - 1;
        if (start + 1 > len) {
            return null;
        }
        if (start + 1 == len) {
            return Util.parseLast(statement, pos, start);
        }
        return Util.parseTail(statement, pos, start);
    }

    public static Object parseLast(Statement statement, Constructor.Position pos, int start) throws ScriptException {
        Object last = Util.getElement(statement, pos, start);
        if (last instanceof Statement) {
            last = ((Statement)last).analyze();
        } else if (last instanceof Constructor) {
            last = new Invocation(statement.getEngine(), statement.getContext(), new Object[]{last}, statement.line()).analyze();
        }
        return Util.unwrap(last);
    }

    public static Object parseTail(Statement statement, Constructor.Position pos, int start) throws ScriptException {
        ArrayList<Object> buffer = new ArrayList<Object>(statement.length() - 1);
        for (int i = start; i < statement.length() - 1; ++i) {
            buffer.add(Util.getElement(statement, pos, i));
        }
        Object analyzed = new Invocation(statement.getEngine(), statement.getContext(), statement.line(), statement.column(), null, buffer, false).analyze();
        return Util.unwrap(analyzed);
    }

    public static Object[] backup(ScriptContext ctx, String[] params) {
        Object[] bak = new Object[params.length];
        for (int i = 0; i < bak.length; ++i) {
            bak[i] = Util.get(ctx, params[i]);
        }
        return bak;
    }

    public static void restore(ScriptContext ctx, String[] params, Object[] args) {
        int len = Math.min(params.length, args.length);
        for (int i = 0; i < len; ++i) {
            Util.set(ctx, params[i], args[i]);
        }
    }

    public static void clearSignal(ScriptContext ctx) {
        ((LifeScriptContext)ctx).clearSignal();
    }

    public static boolean takeBreak(ScriptContext ctx) {
        return ((LifeScriptContext)ctx).takeSignal() != 0;
    }

    public static boolean isBreak(ScriptContext ctx) {
        return ((LifeScriptContext)ctx).getSignal() != 0;
    }

    public static void setSignal(ScriptContext ctx, int signal) {
        ((LifeScriptContext)ctx).setSignal(signal);
    }

    public static boolean objectToBoolean(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof CharSequence) {
            return ((CharSequence)value).length() > 0;
        }
        if (value instanceof Integer) {
            return (Integer)value != 0;
        }
        if (value instanceof Long) {
            return (Long)value != 0L;
        }
        if (value instanceof Number) {
            double d = ((Number)value).doubleValue();
            return d != 0.0;
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value) > 0;
        }
        if (value instanceof Collection) {
            return ((Collection)value).size() > 0;
        }
        if (value instanceof Map) {
            return ((Map)value).size() > 0;
        }
        if (value instanceof Nullable) {
            return !((Nullable)value).isNull();
        }
        return value != Undefined.VALUE;
    }

    public static void checkPatternStr(Map<String, Object> ctx, String patternStr) {
        if (ctx.containsKey(DISABLE_REG_EXPR_CHECK)) {
            return;
        }
        if (patternStr != null) {
            if (patternStr.length() > 2 && patternStr.indexOf(63) > 0) {
                String text = ResManager.loadKDString("\u6b63\u5219\u6a21\u5f0f\u4e32\u4e0d\u5141\u8bb8\u5305\u542b\u201c?\u201c\uff0c\u590d\u6742\u5339\u914d\u903b\u8f91\u8bf7\u6539\u7528String.indexOf\u811a\u672c\u51fd\u6570\u6216\u5176\u4ed6\u65b9\u5f0f\u5b9e\u73b0\u3002", "Util_5", "isc-iscb-util", new Object[0]);
                throw new IllegalArgumentException(text);
            }
        } else {
            throw new IllegalArgumentException(ResManager.loadKDString("\u6b63\u5219\u6a21\u5f0f\u4e32\u4e0d\u5141\u8bb8\u4e3a\u7a7a", "Util_6", "isc-iscb-util", new Object[0]));
        }
    }

    public static void rewrite(Throwable err, String newMsg) {
        if (omitted) {
            return;
        }
        Field f = detailMessage;
        if (f == null) {
            try {
                f = Throwable.class.getDeclaredField("detailMessage");
                f.setAccessible(true);
                detailMessage = f;
            }
            catch (Throwable e) {
                omitted = true;
            }
        }
        if (f != null) {
            try {
                f.set(err, newMsg);
            }
            catch (Throwable e) {
                omitted = true;
            }
        }
        if (err instanceof IscBizException) {
            ErrorCode c = ((IscBizException)err).getErrorCode();
            Util.rewrite(c, newMsg);
        }
    }

    private static void rewrite(ErrorCode c, String newMsg) {
        if (omitted2) {
            return;
        }
        Field f = codeMessage;
        if (f == null) {
            try {
                f = ErrorCode.class.getDeclaredField("message");
                f.setAccessible(true);
                codeMessage = f;
            }
            catch (Throwable e) {
                omitted2 = true;
            }
        }
        if (f != null) {
            try {
                f.set(c, newMsg);
            }
            catch (Throwable e) {
                omitted2 = true;
            }
        }
    }

    public static String formatException(Exception e) {
        String msg = e.getMessage();
        StackTraceElement[] stackTrace = e.getStackTrace();
        if (stackTrace != null && stackTrace.length > 0 && "\u811a\u672c".equals(stackTrace[0].getClassName())) {
            msg = msg + "\n\u811a\u672c\uff1a" + stackTrace[0].getMethodName() + "\n\u884c\u53f7:" + stackTrace[0].getLineNumber();
        }
        return msg;
    }

    static {
        omitted = false;
        omitted2 = false;
    }
}

