/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script.accessor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import kd.ai.gai.dataentity.resource.ResManager;
import kd.ai.gai.flow.misc.Pair;
import kd.ai.gai.flow.script.LifeScriptContext;
import kd.ai.gai.flow.script.LifeScriptEngine;
import kd.ai.gai.flow.script.ScriptContextWrapper;
import kd.ai.gai.flow.script.Util;
import kd.ai.gai.flow.script.accessor.NameAccessorImpl;
import kd.ai.gai.flow.script.context.Context;
import kd.ai.gai.flow.script.context.MapContext;
import kd.ai.gai.flow.script.core.Evaluator;
import kd.ai.gai.flow.script.parser.Program;

public class PathAccessor
implements Evaluator {
    private int line;
    private Item[] _path;
    private boolean is_array;

    public static LifeScriptContext createScriptContext(ScriptContext current, Object src, ScriptContext root, Object ... params) {
        PathContext ctx = PathAccessor.createDataContext(current, src, root, params);
        LifeScriptContext sctx = (LifeScriptContext)current;
        LifeScriptContext new_current = new LifeScriptContext(ctx, sctx.isMemoryControlEnabled());
        new_current.setProgram(sctx.getProgram());
        ctx.current = new_current;
        return new_current;
    }

    private static PathContext createDataContext(ScriptContext parent, Object src, ScriptContext root, Object ... params) {
        PathContext ctx = new PathContext(parent, src, root, params);
        if (src instanceof Context) {
            ctx.binding = (Context)src;
        } else if (src instanceof Map) {
            ctx.binding = new MapContext((Map)src, false);
        } else if (src instanceof ScriptContext) {
            ctx.binding = new ScriptContextWrapper((ScriptContext)src);
        } else if (src instanceof Map.Entry) {
            Map.Entry e = (Map.Entry)src;
            ctx.binding = new Pair(e.getKey(), e.getValue());
        }
        return ctx;
    }

    public static Object parse(String path, Map<String, Object> context, LifeScriptEngine engine, int line) throws ScriptException {
        if (path.indexOf(47) < 0 && path.indexOf(91) < 0) {
            return Util.get(path, context, engine);
        }
        return new PathAccessor(path, line, context, engine);
    }

    private PathAccessor(String path, int line, Map<String, Object> context, LifeScriptEngine engine) throws ScriptException {
        String[] tmp = path.split("/");
        if (tmp[0].length() == 0) {
            tmp[0] = "#";
        }
        this._path = new Item[tmp.length];
        StringBuilder stub = new StringBuilder();
        boolean is_array = false;
        for (int i = 0; i < tmp.length; ++i) {
            Item item;
            stub.append(i == 0 ? "" : "/").append(tmp[i]);
            this._path[i] = item = new Item(stub.toString(), tmp[i], context, engine);
            is_array = is_array || item.isArray && !item.oneOnly;
        }
        this.line = line;
        this.is_array = is_array;
    }

    @Override
    public Object eval(ScriptContext ctx) {
        ArrayList<Object> result = new ArrayList<Object>();
        this.visit(ctx, ctx, 0, result);
        if (this.is_array) {
            return result;
        }
        switch (result.size()) {
            case 1: {
                return result.get(0);
            }
            case 0: {
                return null;
            }
        }
        return result;
    }

    private void visit(ScriptContext current, ScriptContext root, int index, List<Object> result) {
        Item item = this._path[index];
        Object tar = item.get(current, root);
        if (++index == this._path.length) {
            if (tar instanceof Iterable) {
                for (Object e : (Iterable)tar) {
                    result.add(e);
                }
            } else {
                result.add(tar);
            }
        } else if (tar instanceof Iterable) {
            for (Object e : (Iterable)tar) {
                LifeScriptContext new_current = PathAccessor.createScriptContext(current, e, root, new Object[0]);
                this.visit(new_current, root, index, result);
            }
        } else {
            String name = item.name;
            ScriptContext new_current = "..".equals(name) || "#".equals(name) || "_".equals(name) || ".".equals(name) ? (ScriptContext)Util.get(current, name) : PathAccessor.createScriptContext(current, tar, root, new Object[0]);
            this.visit(new_current, root, index, result);
        }
    }

    public Path path() {
        return new Path();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this._path.length; ++i) {
            if (i > 0) {
                sb.append('/');
            }
            sb.append(this._path[i]);
        }
        return sb.toString();
    }

    public class Path {
        private int _index = 0;

        private Path() {
        }

        public boolean next() {
            return ++this._index < PathAccessor.this._path.length;
        }

        public int index() {
            return this._index;
        }

        public boolean hasFilter() {
            return PathAccessor.this._path[this._index].filter != null;
        }

        public void reset(int index) {
            this._index = index;
        }

        public Object get(ScriptContext current, ScriptContext root) {
            return PathAccessor.this._path[this._index].get(current, root);
        }
    }

    private class Item {
        private String stub;
        private String name;
        private boolean isArray;
        private boolean oneOnly;
        private Object filter;
        private String text;

        Object get(ScriptContext parent, ScriptContext root) {
            Object value = NameAccessorImpl.getValue(this.stub, this.name, parent, true, PathAccessor.this.line);
            if (value == null) {
                return null;
            }
            if (this.filter == null) {
                if (this.isArray) {
                    return this.toList(value);
                }
                return value;
            }
            if (this.isArray) {
                return this.filterList(value, parent, root);
            }
            Object filter = Util.eval(parent, this.filter);
            if (filter instanceof Integer) {
                int index = (Integer)filter;
                return this.getFromList(value, index);
            }
            if (value instanceof Map) {
                return ((Map)value).get(filter);
            }
            if (value instanceof Context && filter instanceof CharSequence) {
                return ((Context)value).get(filter.toString());
            }
            throw new UnsupportedOperationException(filter + ":" + this.filter);
        }

        private Object getFromList(Object values, int index) {
            List<?> list = this.toList(values);
            if (index > 0) {
                return index <= list.size() ? list.get(index - 1) : null;
            }
            if (index < 0) {
                int i = index + list.size();
                return i >= 0 ? list.get(i) : null;
            }
            throw new UnsupportedOperationException(ResManager.loadKDString("\u8bf7\u52ff\u4f7f\u75280\u8868\u793a\u7b2c\u4e00\u884c\u3002\u6b63\u786e\u7528\u6cd5\u662f\uff1a1\u8868\u793a\u7b2c\u4e00\u884c\uff0c-1\u8868\u793a\u5012\u6570\u7b2c\u4e00\u884c\u3002", "PathAccessor_0", "isc-iscb-util", new Object[0]));
        }

        private Object filterList(Object values, ScriptContext parent, ScriptContext root) {
            List<?> list = this.toList(values);
            ArrayList returns = new ArrayList(list.size());
            for (Object e : list) {
                LifeScriptContext current = PathAccessor.createScriptContext(parent, e, root, "_ROWNUM_", returns.size() + 1);
                boolean matched = Util.objectToBoolean(Util.eval(current, this.filter));
                if (!matched) continue;
                if (this.oneOnly) {
                    return e;
                }
                returns.add(e);
            }
            return returns;
        }

        private List<?> toList(Object value) {
            if (value instanceof List) {
                return (List)value;
            }
            if (value instanceof Collection) {
                return Arrays.asList(((Collection)value).toArray());
            }
            if (value instanceof Object[]) {
                return Arrays.asList((Object[])value);
            }
            return Collections.singletonList(value);
        }

        private Item(String stub, String name, Map<String, Object> context, LifeScriptEngine engine) throws ScriptException {
            this.stub = stub;
            this.text = name;
            if (name.endsWith("[]")) {
                this.name = name.substring(0, name.length() - "[]".length());
                this.isArray = true;
            } else {
                int left = name.indexOf(91);
                if (left < 0) {
                    this.name = name;
                    this.isArray = false;
                } else {
                    int right = name.lastIndexOf(93);
                    String filter = name.substring(left + 1, right);
                    if (filter.startsWith("?")) {
                        this.oneOnly = true;
                        filter = filter.substring(1);
                    }
                    Program p = engine.compile(filter, context);
                    this.isArray = p.isPredicate();
                    this.filter = p.getImpl();
                    this.name = name.substring(0, left);
                }
            }
            if ("..".equals(this.name)) {
                this.name = "_";
            }
        }

        public String toString() {
            return this.text;
        }
    }

    private static class PathContext
    implements Context {
        private ScriptContext current;
        private ScriptContext parent;
        private Object src;
        private ScriptContext root;
        private Context binding;
        private Map<Object, Object> params;

        public PathContext(ScriptContext parent, Object src, ScriptContext root, Object ... params) {
            this.parent = parent;
            this.src = src;
            this.root = root;
            this.params = new HashMap<Object, Object>(params.length);
            for (int i = 0; i < params.length; ++i) {
                this.params.put(params[i], params[++i]);
            }
        }

        @Override
        public Object get(String property) {
            Object value;
            switch (property.length()) {
                case 0: {
                    return this.root;
                }
                case 1: {
                    if ("$".equals(property)) {
                        return this.src;
                    }
                    if ("_".equals(property)) {
                        return this.parent;
                    }
                    if ("#".equals(property)) {
                        return this.root;
                    }
                    if (!"@".equals(property) && !".".equals(property)) break;
                    return this.current;
                }
                case 2: {
                    if (!"..".equals(property)) break;
                    return this.parent;
                }
                default: {
                    if (!"this".equals(property)) break;
                    return this.src;
                }
            }
            if (this.binding != null && (value = this.binding.get(property)) != null) {
                return value;
            }
            return this.params.get(property);
        }

        @Override
        public boolean set(String property, Object value) {
            return false;
        }

        @Override
        public boolean contains(String property) {
            if ("$".equals(property) || "this".equals(property)) {
                return true;
            }
            if ("_".equals(property) || "..".equals(property)) {
                return true;
            }
            if ("#".equals(property) || "".equals(property)) {
                return true;
            }
            if ("@".equals(property) || ".".equals(property)) {
                return true;
            }
            if (this.binding != null) {
                return this.binding.contains(property);
            }
            return false;
        }
    }
}

