/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script.analyzer.expr;

import java.util.Map;
import javax.script.ScriptException;
import kd.ai.gai.flow.script.LifeScriptEngine;
import kd.ai.gai.flow.script.Util;
import kd.ai.gai.flow.script.analyzer.expr.ColonOperator;
import kd.ai.gai.flow.script.analyzer.expr.CommaOperator;
import kd.ai.gai.flow.script.analyzer.expr.DecisionOperator;
import kd.ai.gai.flow.script.analyzer.expr.DualOperator;
import kd.ai.gai.flow.script.analyzer.expr.GroupPrehandle;
import kd.ai.gai.flow.script.analyzer.expr.ListConstructor;
import kd.ai.gai.flow.script.analyzer.expr.MapConstructor;
import kd.ai.gai.flow.script.analyzer.expr.MemberAccess;
import kd.ai.gai.flow.script.analyzer.expr.MonoOperator;
import kd.ai.gai.flow.script.core.Analyzer;
import kd.ai.gai.flow.script.core.BlockEnd;
import kd.ai.gai.flow.script.core.NotExpression;
import kd.ai.gai.flow.script.core.Operator;
import kd.ai.gai.flow.script.core.Statement;

public class ExprAnalyzer
implements Analyzer {
    public static final Analyzer INS = new ExprAnalyzer();

    private ExprAnalyzer() {
    }

    @Override
    public Object analyze(Statement statement) throws ScriptException {
        if (this.isNotExpression(statement)) {
            return statement;
        }
        if (statement.terminator() == BlockEnd.LIST) {
            return ListConstructor.create(statement);
        }
        if (statement.terminator() == BlockEnd.BLOCK) {
            if (statement.length() == 0) {
                return new MapConstructor(new Object[0][], statement.line());
            }
            if (!this.isMapConstructor(statement)) {
                return statement;
            }
        } else if (this.isNotLongExpression(statement)) {
            return Util.unwrap(statement);
        }
        DecisionOperator.precheck(statement);
        Object[] elements = this.prepare(statement);
        LifeScriptEngine engine = statement.getEngine();
        Map<String, Object> context = statement.getContext();
        int len = GroupPrehandle.process(engine, context, statement, elements);
        len = MemberAccess.process(engine, context, elements, len, statement);
        len = MonoOperator.process(engine, context, elements, len, statement);
        len = DualOperator.process(engine, context, elements, len, 12, statement);
        len = DecisionOperator.process(engine, context, elements, len);
        len = DualOperator.process(engine, context, elements, len, 19, statement);
        len = ColonOperator.process(engine, context, statement, elements, len);
        len = CommaOperator.process(engine, context, statement, elements, len);
        return this.reconstruct(engine, context, elements, len, statement);
    }

    private boolean isMapConstructor(Statement statement) {
        for (int i = 0; i < statement.length(); ++i) {
            if (statement.get(i) != Operator.COLON) continue;
            return true;
        }
        return false;
    }

    private boolean isNotExpression(Statement statement) {
        if (statement.isBlock()) {
            return true;
        }
        if (statement.length() == 0) {
            return false;
        }
        if (statement.get(0) instanceof NotExpression) {
            return true;
        }
        return statement.terminator() == BlockEnd.PROGRAM;
    }

    private boolean isNotLongExpression(Statement statement) {
        return statement.length() <= 1;
    }

    private Object reconstruct(LifeScriptEngine engine, Map<String, Object> context, Object[] elements, int len, Statement original) {
        if (len == 1) {
            return elements[0];
        }
        if (len < elements.length) {
            Object[] buffer = new Object[len];
            System.arraycopy(elements, 0, buffer, 0, len);
            elements = buffer;
        }
        Statement s = original.reconstruct(elements);
        return s;
    }

    private Object[] prepare(Statement statement) {
        Object[] elements = new Object[statement.length()];
        for (int i = 0; i < elements.length; ++i) {
            Object element;
            elements[i] = element = statement.get(i);
        }
        return elements;
    }

    @Override
    public int priority() {
        return 0;
    }

    public String toString() {
        return "Expr";
    }
}

