/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script.analyzer.expr;

import java.util.Map;
import javax.script.ScriptException;
import kd.ai.gai.flow.script.LifeScriptEngine;
import kd.ai.gai.flow.script.analyzer.ConstructorAnalyzer;
import kd.ai.gai.flow.script.analyzer.expr.Util;
import kd.ai.gai.flow.script.core.Constructor;
import kd.ai.gai.flow.script.core.Operator;
import kd.ai.gai.flow.script.core.Statement;
import kd.ai.gai.flow.script.statement.Invocation;

public class MonoOperator {
    public static int process(LifeScriptEngine engine, Map<String, Object> context, Object[] elements, int len, Statement smt) throws ScriptException {
        int line = smt.line();
        return MonoOperator.process(engine, context, elements, len, line);
    }

    public static int process(LifeScriptEngine engine, Map<String, Object> context, Object[] elements, int len, int line) throws ScriptException {
        len = MonoOperator.processSuffixMonoOperator(engine, context, elements, len, line);
        len = MonoOperator.processPrefixMonoOperator(engine, context, elements, len, line);
        return len;
    }

    private static int processPrefixMonoOperator(LifeScriptEngine engine, Map<String, Object> context, Object[] elements, int len, int line) throws ScriptException {
        int i;
        if (len < 2) {
            return len;
        }
        int p = len - 1;
        for (i = len - 2; i >= 0; --i) {
            Object current = elements[i];
            if (current instanceof Operator) {
                Operator op = (Operator)current;
                if (Util.isPrefixMonoOperator(op, elements, i - 1)) {
                    Object next = Util.getNextElement(elements, p, len);
                    if (op instanceof Constructor) {
                        elements[p] = ConstructorAnalyzer.INS.analyze(new Invocation(engine, context, new Object[]{op, next}, line));
                        continue;
                    }
                    Util.checkOperand(next);
                    elements[p] = new Invocation(engine, context, new Object[]{op, next}, line);
                    continue;
                }
                elements[--p] = current;
                continue;
            }
            elements[--p] = current;
        }
        if (p > 0) {
            len -= p;
            for (i = 0; i < len; ++i) {
                elements[i] = elements[i + p];
            }
        }
        return len;
    }

    private static int processSuffixMonoOperator(LifeScriptEngine engine, Map<String, Object> context, Object[] elements, int len, int line) throws ScriptException {
        if (len < 2) {
            return len;
        }
        int p = 0;
        for (int i = 1; i < len; ++i) {
            Object current = elements[i];
            if (current instanceof Operator) {
                Operator op = (Operator)current;
                if (Util.isSuffixMonoOperator(op, elements, p)) {
                    Object prior = Util.getPriorElement(elements, p);
                    Util.checkOperand(prior);
                    if (op instanceof Constructor) {
                        elements[p] = ConstructorAnalyzer.INS.analyze(new Invocation(engine, context, new Object[]{prior, op}, line));
                        continue;
                    }
                    elements[p] = new Invocation(engine, context, new Object[]{op, prior}, line);
                    continue;
                }
                elements[++p] = current;
                continue;
            }
            elements[++p] = current;
        }
        return p + 1;
    }
}

