/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script.core;

import java.util.Collection;
import java.util.HashMap;
import kd.ai.gai.flow.except.IscBizException;
import kd.ai.gai.flow.script.LifeScriptEngine;
import kd.ai.gai.flow.script.core.Identifier;
import kd.ai.gai.flow.script.core.ToolKit;

public abstract class AbstractToolKit
implements ToolKit {
    private HashMap<String, Identifier> pool = new HashMap();

    @Override
    public Collection<Identifier> tools() {
        return this.pool.values();
    }

    @Override
    public final Identifier get(String name) {
        Identifier fn = this.pool.get(name);
        if (fn != null) {
            return fn;
        }
        throw new UnsupportedOperationException(this + " doesn't support " + name + "!");
    }

    protected final void register(Identifier fn) {
        this.register(fn.name(), fn);
    }

    protected final void register(String key, Identifier value) {
        if (this.pool.containsKey(key)) {
            throw new IscBizException(key + " was registered in " + this + "!");
        }
        this.pool.put(key, value);
    }

    @Override
    public final String name() {
        String suffix;
        String tmp = this.getClass().getSimpleName();
        if (tmp.endsWith(suffix = ToolKit.class.getSimpleName())) {
            return tmp.substring(0, tmp.length() - suffix.length());
        }
        return tmp;
    }

    @Override
    public void registerOtherElements(LifeScriptEngine engine) {
    }

    public final String toString() {
        return this.name();
    }
}

