/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script.core;

import java.util.Collection;
import java.util.Set;
import javax.script.ScriptContext;
import kd.ai.gai.flow.dt.DataType;
import kd.ai.gai.flow.dt.TypedArray;
import kd.ai.gai.flow.dt.TypedSet;
import kd.ai.gai.flow.script.core.Reference;

public class TypedReference
extends Reference {
    private DataType type;

    protected TypedReference(String name, DataType type) {
        super(name);
        this.type = type;
    }

    @Override
    public Object set(ScriptContext ctx, Object value) {
        return super.set(ctx, TypedReference.narrow(this.type, value));
    }

    static Object narrow(DataType type, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Set) {
            return TypedReference.narrowSet(type, (Set)value);
        }
        if (value instanceof Collection) {
            return TypedReference.narrowCollection(type, (Collection)value);
        }
        if (value instanceof Object[]) {
            return TypedReference.narrowArray(type, (Object[])value);
        }
        return type.narrow(value);
    }

    private static Object narrowArray(DataType type, Object[] value) {
        TypedArray list = new TypedArray(type);
        for (Object e : value) {
            list.add(e);
        }
        return list;
    }

    private static Object narrowCollection(DataType type, Collection<?> value) {
        TypedArray list = new TypedArray(type);
        list.addAll((Collection<? extends Object>)value);
        return list;
    }

    private static Object narrowSet(DataType type, Set<?> value) {
        TypedSet set = new TypedSet(type);
        set.addAll((Collection<? extends Object>)value);
        return set;
    }
}

