/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script.data;

import java.util.Arrays;
import java.util.UUID;
import kd.ai.gai.flow.dt.i.Hex;
import kd.ai.gai.flow.script.misc.UuidUtil;

public final class BinaryString
implements Comparable<BinaryString> {
    private byte[] bytes;
    private volatile String s;

    public BinaryString() {
        this.bytes = UuidUtil.toBytes(UUID.randomUUID());
    }

    public BinaryString(String hex) {
        this.bytes = BinaryString.toBytes(hex, 0);
    }

    public BinaryString(byte[] bytes) {
        this.bytes = (byte[])bytes.clone();
    }

    public BinaryString(byte[] bytes, int offset, int count) {
        if (offset < 0) {
            throw new StringIndexOutOfBoundsException(offset);
        }
        if (count < 0) {
            throw new StringIndexOutOfBoundsException(count);
        }
        if (offset > bytes.length - count) {
            throw new StringIndexOutOfBoundsException(offset + count);
        }
        this.bytes = Arrays.copyOfRange(bytes, offset, offset + count);
    }

    public int getLength() {
        return this.bytes.length;
    }

    public String toString() {
        if (this.s == null) {
            this.s = Hex.encode(this.bytes);
        }
        return this.s;
    }

    public byte[] getBytes() {
        return (byte[])this.bytes.clone();
    }

    public byte get(int index) {
        return this.bytes[index];
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.bytes);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BinaryString other = (BinaryString)obj;
        return Arrays.equals(this.bytes, other.bytes);
    }

    public static byte[] toBytes(Object value, int maxLen) {
        BinaryString b;
        if ("".equals(value) || value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof UUID) {
            return UuidUtil.toBytes((UUID)value);
        }
        if (value instanceof BinaryString && ((b = (BinaryString)value).getLength() == 16 || maxLen != 16)) {
            return b.getBytes();
        }
        String s = value.toString().trim();
        if (s.length() == 0) {
            return null;
        }
        if (UuidUtil.isUuid(s)) {
            return UuidUtil.toBytes(UuidUtil.toUUID(s));
        }
        if (maxLen == 16) {
            StringBuilder sb = new StringBuilder(s);
            while (sb.length() < 32) {
                sb.append('f');
            }
            s = sb.toString();
        }
        if ((s.length() & 1) != 0) {
            s = "0" + s;
        }
        return Hex.decode(s);
    }

    @Override
    public int compareTo(BinaryString b) {
        if (b == null) {
            return 1;
        }
        byte[] b0 = this.bytes;
        byte[] b1 = b.bytes;
        int len = Math.min(b0.length, b1.length);
        for (int i = 0; i < len; ++i) {
            if (b0[i] < b1[i]) {
                return -1;
            }
            if (b0[i] <= b1[i]) continue;
            return 1;
        }
        if (b0.length > b1.length) {
            return 1;
        }
        if (b0.length < b1.length) {
            return -1;
        }
        return 0;
    }

    public BinaryString substring(int i, int j) {
        byte[] buffer = new byte[j - i];
        int end = Math.min(j, this.bytes.length);
        int k = 0;
        while (i < end) {
            buffer[k] = this.bytes[i];
            ++i;
            ++k;
        }
        return new BinaryString(buffer);
    }
}

