/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script.data.fsm;

import java.util.ArrayList;
import java.util.HashMap;
import kd.ai.gai.flow.script.data.fsm.Action;

class State {
    private HashMap<Character, State> transitions = new HashMap(8);
    private ArrayList<Action> actions;
    private boolean terminal = false;
    private String pattern;

    State() {
    }

    boolean isTerminal() {
        return this.terminal;
    }

    void setTerminal(String pattern, Action action) {
        this.addActions(action);
        this.pattern = pattern;
        this.terminal = true;
        this.transitions.clear();
        this.transitions = null;
    }

    private void addActions(Action action) {
        if (action != null) {
            if (this.actions == null) {
                this.actions = new ArrayList();
            }
            this.actions.add(action);
        }
    }

    void setTargetFor(State target, Character c) {
        this.transitions.put(c, target);
    }

    State getTargetFor(Character c) {
        return this.transitions.get(c);
    }

    public void exec(String input, Object param) {
        if (this.actions != null) {
            for (int i = 0; i < this.actions.size(); ++i) {
                this.actions.get(i).doAction(input, param, this.pattern);
            }
        }
    }
}

