/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script.encoding;

import java.nio.charset.Charset;
import java.util.Locale;
import kd.ai.gai.flow.dt.D;
import kd.ai.gai.flow.script.encoding.Base64;
import kd.ai.gai.flow.script.encoding.Hex;

public abstract class Encoding {
    public static final Charset US_ASCII = Charset.forName("US-ASCII");
    public static final Encoding HEX = new Hex();
    public static final Encoding BASE64 = new Base64();
    private static char[] B64 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '_', '$', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    public final String encode(String s) {
        byte[] tmp = Encoding.stringToUtf8(s);
        byte[] encoded = this.encode(tmp);
        return Encoding.utf8ToString(encoded);
    }

    public static byte[] stringToUtf8(String s) {
        if (s == null) {
            return new byte[0];
        }
        return s.getBytes(D.UTF_8);
    }

    public static String utf8ToString(byte[] utf8) {
        return new String(utf8, D.UTF_8);
    }

    public static StringBuilder xmlEncode(String s) {
        return Encoding.xmlEncode(s, new StringBuilder());
    }

    public static StringBuilder xmlEncode(String s, StringBuilder sb) {
        if (s == null) {
            return sb;
        }
        block7: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\'': {
                    sb.append("&#39;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&#34;");
                    continue block7;
                }
                case '<': {
                    sb.append("&#60;");
                    continue block7;
                }
                case '>': {
                    sb.append("&#62;");
                    continue block7;
                }
                case '&': {
                    sb.append("&#38;");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb;
    }

    public final String decode(String s) {
        byte[] tmp = Encoding.stringToUtf8(s);
        byte[] decoded = this.decode(tmp);
        return Encoding.utf8ToString(decoded);
    }

    public abstract byte[] encode(byte[] var1);

    public abstract byte[] decode(byte[] var1);

    public static boolean isQName(String s) {
        if (s.length() == 0) {
            return false;
        }
        char c = s.charAt(0);
        if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
            return false;
        }
        for (int i = 1; i < s.length(); ++i) {
            c = s.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_') continue;
            return false;
        }
        return true;
    }

    public static String int2hex(int i) {
        return Integer.toHexString(i).toUpperCase(Locale.ENGLISH);
    }

    public static String encodeHTML(String s) {
        StringBuilder html = new StringBuilder(s.length() + 64);
        boolean priorIsLn = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    html.append("&lt;");
                    break;
                }
                case '>': {
                    html.append("&gt;");
                    break;
                }
                case '\'': {
                    html.append("&apos;");
                    break;
                }
                case '\"': {
                    html.append("&quot;");
                    break;
                }
                case '&': {
                    html.append("&amp;");
                    break;
                }
                case '\r': {
                    html.append("<br>");
                    break;
                }
                case '\n': {
                    if (priorIsLn) break;
                    html.append("<br>");
                    break;
                }
                case ' ': {
                    html.append("&nbsp;");
                    break;
                }
                case '\t': {
                    html.append("&nbsp;&nbsp;&nbsp;&nbsp;");
                    break;
                }
                default: {
                    html.append(c);
                }
            }
            priorIsLn = c == '\r';
        }
        return html.toString();
    }

    public static String pesudoBase64(long v) {
        char[] chars = new char[11];
        for (int i = 10; i >= 0; --i) {
            int index = (int)(0x3FL & v);
            v >>>= 6;
            chars[i] = B64[index];
        }
        return new String(chars);
    }
}

